/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;

public class MIVarUpdateInfo
extends MIInfo {
    MIVarChange[] changeList;

    public MIVarUpdateInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    public MIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("changelist") && (value = results[i].getMIValue()) instanceof MITuple) {
                    this.parseChangeList((MITuple)value, aList);
                }
                ++i;
            }
        }
        this.changeList = aList.toArray(new MIVarChange[aList.size()]);
    }

    void parseChangeList(MITuple tuple, List aList) {
        MIResult[] results = tuple.getMIResults();
        MIVarChange change = null;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("name")) {
                change = new MIVarChange(str);
                aList.add(change);
            } else if (var.equals("in_scope")) {
                if (change != null) {
                    change.setInScope("true".equals(str));
                }
            } else if (var.equals("type_changed") && change != null) {
                change.setChanged("true".equals(str));
            }
            ++i;
        }
    }
}

