/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICExpressionEvaluator;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ExpressionDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class AddExpressionActionDelegate
extends AbstractEditorActionDelegate {
    public void run(IAction action) {
        String text = this.getSelectedText();
        ExpressionDialog dlg = new ExpressionDialog(this.getShell(), text);
        if (dlg.open() != 0) {
            return;
        }
        this.createExpression(dlg.getExpression());
    }

    protected String getSelectedText() {
        ISelection selection = this.getTargetSelection();
        if (selection != null && selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText().trim();
        }
        return "";
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private void createExpression(final String text) {
        Display display = CDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    IExpression expression = CDebugModel.createExpression((IDebugTarget)AddExpressionActionDelegate.this.getDebugTarget(), (String)text);
                    DebugPlugin.getDefault().getExpressionManager().addExpression(expression);
                    AddExpressionActionDelegate.this.showExpressionView();
                }
                catch (DebugException e) {
                    CDebugUIPlugin.errorDialog("Evaluation of expression failed.", e);
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && target1 instanceof ICExpressionEvaluator) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && target instanceof ICExpressionEvaluator) {
            this.setDebugTarget(target);
        }
    }

    protected void showExpressionView() {
        CDebugUIPlugin.getDefault();
        IWorkbenchPage page = CDebugUIPlugin.getActivePage();
        if (page != null) {
            IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
            if (part == null) {
                try {
                    page.showView("org.eclipse.debug.ui.ExpressionView");
                }
                catch (PartInitException e) {
                    CDebugUIPlugin.getDefault();
                    CDebugUIPlugin.log(e.getStatus());
                }
            } else {
                page.bringToTop((IWorkbenchPart)part);
            }
        }
    }
}

