/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class CDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fHexButton;
    private Button fPathsButton;
    private Button fAutoDisassemblyButton;
    private PropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$org$eclipse$debug$ui$IDebugView;

    public CDebugPreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        this.setDescription("General settings for C/C++ Debugging.");
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDebugHelpContextIds.C_DEBUG_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createPrimitiveDisplayPreferences(composite);
        this.createSpacer(composite, 1);
        this.createViewSettingPreferences(composite);
        this.createSpacer(composite, 1);
        this.createDisassemblySettingPreferences(composite);
        this.setValues();
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        Group comp = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        comp.setLayoutData((Object)gd);
        comp.setText(labelText);
        return comp;
    }

    private void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fHexButton.setSelection(store.getBoolean(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES));
        this.fPathsButton.setSelection(store.getBoolean(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS));
        this.fAutoDisassemblyButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY));
    }

    public void init(IWorkbench workbench) {
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, false);
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, true);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_AUTO_DISASSEMBLY, false);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createPrimitiveDisplayPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, "Primitive type display options");
        this.fHexButton = this.createCheckButton(comp, "Display &hexadecimal values (short, char, int, long)");
    }

    private void createViewSettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, "Opened view default settings");
        this.fPathsButton = this.createCheckButton(comp, "Show full &paths");
    }

    private void createDisassemblySettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, "Disassembly options");
        this.fAutoDisassemblyButton = this.createCheckButton(comp, "Automatically switch to &disassembly mode");
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        this.storeValues();
        if (this.getPropertyChangeListener().hasStateChanged()) {
            this.refreshViews();
        }
        CDebugUIPlugin.getDefault().savePluginPreferences();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void refreshViews() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = CDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                IWorkbenchPage page = null;
                int i = 0;
                while (i < windows.length) {
                    page = windows[i].getActivePage();
                    if (page != null) {
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.ExpressionView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.VariableView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.cdt.debug.ui.RegitersView");
                    }
                    ++i;
                }
            }
        });
    }

    protected void refreshViews(IWorkbenchPage page, String viewID) {
        Viewer viewer;
        IDebugView adapter;
        IViewPart part = page.findView(viewID);
        if (part != null && (adapter = (IDebugView)part.getAdapter(class$org$eclipse$debug$ui$IDebugView == null ? (class$org$eclipse$debug$ui$IDebugView = CDebugPreferencePage.class$("org.eclipse.debug.ui.IDebugView")) : class$org$eclipse$debug$ui$IDebugView)) != null && (viewer = adapter.getViewer()) instanceof StructuredViewer) {
            ((StructuredViewer)viewer).refresh();
        }
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, this.fHexButton.getSelection());
        store.setValue(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, this.fPathsButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_AUTO_DISASSEMBLY, this.fAutoDisassemblyButton.getSelection());
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fHexButton.setSelection(store.getDefaultBoolean(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES));
        this.fAutoDisassemblyButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        protected PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES)) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_CHAR_VALUES)) {
                this.fHasStateChanged = true;
            }
        }

        protected boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

