/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;

public class ConsoleOutputStream
extends OutputStream {
    protected StringBuffer fBuffer = new StringBuffer(256);
    protected StringBuffer fContent = new StringBuffer();
    protected int pos = 0;

    public synchronized void flush() throws IOException {
        String content = this.fBuffer.toString();
        this.fBuffer.setLength(0);
        this.fContent.append(content);
    }

    public String getContent(int len) {
        String s = null;
        try {
            s = this.fContent.substring(len);
        }
        catch (StringIndexOutOfBoundsException e) {
            s = "";
        }
        return s;
    }

    public String getContent() {
        if (this.pos >= this.fContent.length()) {
            this.pos = 0;
        }
        String s = this.getContent(this.pos);
        this.pos += s.length();
        return s;
    }

    public void clear() {
        this.fBuffer.setLength(0);
        this.fContent.setLength(0);
        this.pos = 0;
    }

    public synchronized void write(int c) throws IOException {
        this.fBuffer.append((char)c);
        if (this.fBuffer.length() > 250) {
            this.flush();
        }
    }
}

