/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.ElfRunner;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class BinaryContainer
extends Parent
implements IBinaryContainer {
    CProject cProject;
    private long modificationStamp;

    public BinaryContainer(CProject cProject) {
        this(cProject, "bin");
    }

    public BinaryContainer(CProject cProject, String name) {
        super(cProject, null, name, 30);
        this.cProject = cProject;
        IProject project = cProject.getProject();
        IFolder folder = project.getFolder("Virtual.bin");
        this.setUnderlyingResource((IResource)folder);
    }

    public IBinary[] getBinaries() {
        ICElement[] e = this.getChildren(true);
        IBinary[] b = new IBinary[e.length];
        System.arraycopy(e, 0, b, 0, e.length);
        return b;
    }

    public boolean hasChildren() {
        return this.getChildren(true).length > 0;
    }

    public ICElement[] getChildren() {
        return this.getChildren(false);
    }

    public ICElement[] getChildren(boolean sync) {
        if (!this.cProject.hasRunElf()) {
            this.cProject.setRunElf(true);
            ElfRunner runner = new ElfRunner(this.cProject);
            Thread thread = new Thread((Runnable)runner, "Elf Runner");
            thread.setDaemon(true);
            thread.start();
            if (sync) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return super.getChildren();
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    void addChildIfExec(CoreModel factory, IFile file) {
        IBinary bin;
        ICFile celement;
        if (!CoreModel.isTranslationUnit(file) && (celement = factory.create(file)) != null && celement instanceof IBinary && ((bin = (IBinary)celement).isExecutable() || bin.isSharedLib())) {
            this.addChild(bin);
        }
    }

    public CElementInfo createElementInfo() {
        return new CElementInfo(this);
    }

    class Visitor
    implements IResourceVisitor {
        CoreModel factory = CoreModel.getDefault();
        BinaryContainer cbin;

        public Visitor(BinaryContainer element) {
            this.cbin = element;
        }

        public boolean visit(IResource res) throws CoreException {
            if (res instanceof IFile) {
                this.cbin.addChildIfExec(this.factory, (IFile)res);
                return false;
            }
            return true;
        }
    }
}

