/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.errorparsers.GASErrorParser;
import org.eclipse.cdt.internal.errorparsers.GCCErrorParser;
import org.eclipse.cdt.internal.errorparsers.GLDErrorParser;
import org.eclipse.cdt.internal.errorparsers.IErrorParser;
import org.eclipse.cdt.internal.errorparsers.MakeErrorParser;
import org.eclipse.cdt.internal.errorparsers.VCErrorParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorParserManager {
    private static String PREF_ERROR_PARSER = "errorOutputParser";
    private IProject fProject;
    private IMarkerGenerator fMarkerGenerator;
    private Map fFilesInProject;
    private List fNameConflicts;
    private ArrayList fErrorParsers;
    private Vector fDirectoryStack;
    private IPath fBaseDirectory;
    private String previousLine;
    static String SEPARATOR = System.getProperty("file.separator");

    public ErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), builder);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fFilesInProject = new HashMap();
        this.fNameConflicts = new ArrayList();
        this.fErrorParsers = new ArrayList();
        this.fDirectoryStack = new Vector();
        this.fBaseDirectory = null;
        this.readPreferences();
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return new Path("");
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            if (this.fBaseDirectory.isPrefixOf(dir)) {
                int segments = this.fBaseDirectory.matchingFirstSegments(dir);
                pwd = dir.removeFirstSegments(segments);
            } else {
                pwd = dir;
            }
            this.fDirectoryStack.addElement(pwd);
        }
    }

    public IPath popDirectory() {
        int i = this.fDirectoryStack.size();
        IPath dir = (IPath)this.fDirectoryStack.lastElement();
        if (i != 0) {
            this.fDirectoryStack.removeElementAt(i - 1);
        }
        return dir;
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    protected void addParser(IErrorParser parser) {
        this.fErrorParsers.add(parser);
    }

    private void readPreferences() {
        this.fErrorParsers.clear();
        String parserNames = CCorePlugin.getDefault().getPluginPreferences().getString(PREF_ERROR_PARSER);
        if (parserNames != null && parserNames.length() > 0) {
            StringTokenizer tok = new StringTokenizer(parserNames, ";");
            while (tok.hasMoreElements()) {
                String clName = tok.nextToken();
                try {
                    this.getClass();
                    IErrorParser parser = (IErrorParser)Class.forName(clName).newInstance();
                    this.fErrorParsers.add(parser);
                }
                catch (ClassNotFoundException e) {
                    CCorePlugin.log(e);
                }
                catch (InstantiationException e) {
                    CCorePlugin.log(e);
                }
                catch (IllegalAccessException e) {
                    CCorePlugin.log(e);
                }
                catch (ClassCastException e) {
                    CCorePlugin.log(e);
                }
            }
        }
        if (this.fErrorParsers.size() == 0) {
            this.initErrorParsersArray(this.fErrorParsers);
        }
        this.savePreferences();
    }

    private void initErrorParsersArray(List errorParsers) {
        errorParsers.add(new VCErrorParser());
        errorParsers.add(new GCCErrorParser());
        errorParsers.add(new GLDErrorParser());
        errorParsers.add(new GASErrorParser());
        errorParsers.add(new MakeErrorParser());
    }

    private void savePreferences() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fErrorParsers.size()) {
            buf.append(this.fErrorParsers.get(i).getClass().getName());
            buf.append(';');
            ++i;
        }
        CCorePlugin.getDefault().getPluginPreferences().setValue(PREF_ERROR_PARSER, buf.toString());
    }

    protected void collectFiles(IContainer parent, List result) {
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    result.add(resource);
                } else if (resource instanceof IContainer) {
                    this.collectFiles((IContainer)resource, result);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    /*
     * Loose catch block
     */
    public void parse(String output) {
        block11: {
            this.fFilesInProject.clear();
            this.fNameConflicts.clear();
            ArrayList collectedFiles = new ArrayList();
            this.fBaseDirectory = this.fProject.getLocation();
            this.collectFiles((IContainer)this.fProject, collectedFiles);
            int i = 0;
            while (i < collectedFiles.size()) {
                IFile curr = (IFile)collectedFiles.get(i);
                IFile existing = this.fFilesInProject.put(curr.getName(), curr);
                if (existing != null) {
                    this.fNameConflicts.add(curr.getName());
                }
                ++i;
            }
            BufferedReader rd = new BufferedReader(new StringReader(output));
            String line = rd.readLine();
            while (line != null) {
                this.processLine(line);
                this.previousLine = line;
                line = rd.readLine();
            }
            Object var7_7 = null;
            try {
                rd.close();
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    CCorePlugin.log(e);
                    Object var7_8 = null;
                    try {
                        rd.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    rd.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.fFilesInProject.clear();
        this.fNameConflicts.clear();
        this.fDirectoryStack.removeAllElements();
        this.fBaseDirectory = null;
    }

    private void processLine(String line) {
        int top;
        int i = top = this.fErrorParsers.size() - 1;
        do {
            IErrorParser curr;
            if (!(curr = (IErrorParser)this.fErrorParsers.get(i)).processLine(line, this)) continue;
            if (i != top) {
                Object used = this.fErrorParsers.remove(i);
                this.fErrorParsers.add(used);
                this.savePreferences();
            }
            return;
        } while (--i >= 0);
    }

    public IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        return (IFile)this.fFilesInProject.get(path.lastSegment());
    }

    public boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    public IFile findFilePath(String filePath) {
        IPath path = null;
        Path fp = new Path(filePath);
        if (fp.isAbsolute()) {
            if (this.fBaseDirectory.isPrefixOf((IPath)fp)) {
                int segments = this.fBaseDirectory.matchingFirstSegments((IPath)fp);
                path = fp.removeFirstSegments(segments);
            } else {
                path = fp;
            }
        } else {
            path = this.getWorkingDirectory().append(filePath);
        }
        return this.fProject.getFile(path);
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        if (file == null) {
            this.fMarkerGenerator.addMarker((IResource)this.fProject, lineNumber, desc, severity, varName);
        } else {
            this.fMarkerGenerator.addMarker(file, lineNumber, desc, severity, varName);
        }
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public IPath getBuildCommand() {
        return new Path("");
    }
}

