/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.cdt.internal.ui.dialogs.MessageLine;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;

public class StatusTool {
    public static void applyToStatusLine(MessageLine messageLine, IStatus status) {
        String[] messages = StatusTool.getErrorMessages(status);
        messageLine.setErrorMessage(messages[0]);
        messageLine.setMessage(messages[1]);
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String[] messages = StatusTool.getErrorMessages(status);
        page.setErrorMessage(messages[0]);
        page.setMessage(messages[1]);
    }

    public static String[] getErrorMessages(IStatus status) {
        String message = status.getMessage();
        if (status.matches(4) && !"".equals(message)) {
            return new String[]{message, null};
        }
        if (status.matches(3)) {
            return new String[]{null, message};
        }
        return new String[]{null, null};
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        return max;
    }
}

