/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class SearchForReferencesAction
extends Action {
    private static final String PREFIX = "SearchForReferencesAction.";
    private static final String DIALOG_TITLE = "SearchForReferencesAction.dialog.title";
    private static final String DIALOG_MESSAGE = "SearchForReferencesAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public SearchForReferencesAction(ISelectionProvider provider) {
        super(CPlugin.getResourceString("SearchForReferencesAction.label"));
        this.setDescription(CPlugin.getResourceString("SearchForReferencesAction.description"));
        this.setToolTipText(CPlugin.getResourceString("SearchForReferencesAction.tooltip"));
        if (provider instanceof CContentOutlinePage) {
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
            this.setText("Search for References");
        }
        this.fSelectionProvider = provider;
    }

    public void run() {
        String search_name;
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof ITextSelection) {
            search_name = ((ITextSelection)selection).getText();
            if (search_name.length() == 0) {
                return;
            }
        } else {
            ICElement element = SearchForReferencesAction.getElement(selection);
            if (element == null) {
                return;
            }
            search_name = element.getElementName();
        }
        TextSearchResultCollector col = new TextSearchResultCollector();
        try {
            SearchUI.activateSearchResultView();
            TextSearchScope scope = TextSearchScope.newWorkspaceScope();
            scope.addExtension("c");
            scope.addExtension("h");
            scope.addExtension("cc");
            scope.addExtension("hh");
            TextSearchOperation op = new TextSearchOperation(CPlugin.getWorkspace(), search_name, "", (ISearchScope)scope, col);
            ProgressMonitorDialog context = null;
            Shell shell = new Shell();
            if (context == null) {
                context = new ProgressMonitorDialog(shell);
            }
            try {
                context.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle((InvocationTargetException)ex, (String)"Error", (String)"Error");
            }
            catch (InterruptedException e) {}
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return SearchForReferencesAction.getElement(selection) != null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }
}

