/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.makeview;

import org.eclipse.cdt.core.resources.MakeUtil;
import org.eclipse.cdt.internal.ui.makeview.MakeAction;
import org.eclipse.cdt.internal.ui.makeview.MakeContentProvider;
import org.eclipse.cdt.internal.ui.makeview.MakeLabelProvider;
import org.eclipse.cdt.internal.ui.makeview.MakeTarget;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    TreeViewer viewer;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element instanceof MakeTarget) {
            MakeTarget ta = (MakeTarget)element;
            MakeAction build = new MakeAction(new MakeTarget[]{ta}, this.getViewSite().getShell(), "Build");
            build.run();
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof MakeTarget) {
            final MakeTarget ta = (MakeTarget)element;
            Action add = new Action("Add"){

                public void run() {
                    InputDialog dialog = new InputDialog(MakeView.this.getViewSite().getShell(), "Target Dialog: ", "Enter Target(s): ", null, null);
                    dialog.open();
                    String value = dialog.getValue();
                    if (value != null && value.length() > 0) {
                        IResource res = ta.getResource();
                        MakeUtil.addPersistentTarget((IResource)res, (String)value);
                        MakeView.this.viewer.getControl().setRedraw(false);
                        MakeView.this.viewer.refresh();
                        MakeView.this.viewer.getControl().setRedraw(true);
                        MakeView.this.viewer.expandToLevel((Object)ta, 2);
                    }
                }
            };
            Action del = new Action("Delete"){

                public void run() {
                    String target = ta.toString();
                    if (target != null) {
                        IResource res = ta.getResource();
                        MakeUtil.removePersistentTarget((IResource)res, (String)target);
                        MakeView.this.viewer.getControl().setRedraw(false);
                        MakeView.this.viewer.refresh();
                        MakeView.this.viewer.getControl().setRedraw(true);
                    }
                }
            };
            MakeAction build = new MakeAction(new MakeTarget[]{ta}, this.getViewSite().getShell(), "Build");
            Action refresh = new Action("Refresh"){

                public void run() {
                    MakeView.this.viewer.refresh();
                }
            };
            menu.add((IAction)add);
            menu.add((IAction)del);
            menu.add((IAction)build);
            menu.add((IAction)refresh);
            if (ta.isLeaf()) {
                add.setEnabled(false);
            } else {
                del.setEnabled(false);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakeView.this.contextMenuAboutToShow(manager);
            }
        });
        Control control = this.viewer.getControl();
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.viewer.setInput((Object)new MakeTarget((IResource)ResourcesPlugin.getWorkspace().getRoot()));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MakeView.this.handleDoubleClick(event);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }
}

