/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.swt.MGridData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private IStringButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled;

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 2));
        Control button = this.getChangeControl(parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForControl(1));
        return new Control[]{label, text, button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    public Control getChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            this.fBrowseButton = new Button(parent, 8);
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static MGridData gridDataForControl(int span) {
        MGridData gd = new MGridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public StringButtonDialogField(IStringButtonAdapter adapter) {
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = "!Browse...!";
        this.fButtonEnabled = true;
    }

    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

