/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.File;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectWizardPage
extends WizardPage {
    protected boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private Text projectNameField;
    protected Text locationPathField;
    protected Label locationLabel;
    protected Button browseButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            CProjectWizardPage.this.setLocationForSelection();
            CProjectWizardPage.this.setPageComplete(CProjectWizardPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            CProjectWizardPage.this.setPageComplete(CProjectWizardPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_INDENTATION_WIDTH = 10;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.projectNameField.setFocus();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(CPlugin.getResourceString("CProjectWizardPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CProjectWizardPage.this.useDefaults = useDefaultsButton.getSelection();
                CProjectWizardPage.this.browseButton.setEnabled(!CProjectWizardPage.this.useDefaults);
                CProjectWizardPage.this.locationPathField.setEnabled(!CProjectWizardPage.this.useDefaults);
                CProjectWizardPage.this.locationLabel.setEnabled(!CProjectWizardPage.this.useDefaults);
                CProjectWizardPage.this.setLocationForSelection();
                if (!CProjectWizardPage.this.useDefaults) {
                    CProjectWizardPage.this.locationPathField.setText("");
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(CPlugin.getResourceString("CProjectWizardPage.nameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
        this.projectNameField.setVisible(true);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(CPlugin.getResourceString("CProjectWizardPage.locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(CPlugin.getResourceString("CProjectWizardPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CProjectWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.locationPathField.getText());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.projectNameField.getText();
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(CPlugin.getResourceString("CProjectWizardPage.directoryLabel"));
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.locationPathField.setText(selectedDirectory);
        }
    }

    public CProjectWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
    }

    protected void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.projectNameField.getText());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.projectNameField.getText();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(CPlugin.getResourceString("CProjectWizardPage.projectNameEmpty"));
            return false;
        }
        if (projectFieldContents.indexOf(32) != -1) {
            this.setErrorMessage(CPlugin.getResourceString("CProjectWizardPage.projectContainsSpace"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (!locationFieldContents.equals("")) {
            Path path = new Path("");
            if (!path.isValidPath(locationFieldContents)) {
                this.setErrorMessage(CPlugin.getResourceString("CProjectWizardPage.locationError"));
                return false;
            }
            if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(locationFieldContents))) {
                this.setErrorMessage(CPlugin.getResourceString("CProjectWizardPage.defaultLocationError"));
                return false;
            }
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(CPlugin.getResourceString("CProjectWizardPage.projectExistsMessage"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

