/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.StringTokenizer;
import org.eclipse.cdt.utils.ui.controls.HyperlinkHandler;
import org.eclipse.cdt.utils.ui.controls.IHyperlinkListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ControlFactory {
    private static HyperlinkHandler defaultHyperlinkHandler = new HyperlinkHandler();

    public static void dispose() {
        defaultHyperlinkHandler.dispose();
    }

    public static Control setParentColors(Control control) {
        Composite parent = control.getParent();
        control.setBackground(parent.getBackground());
        control.setForeground(parent.getForeground());
        return control;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        return ControlFactory.createCompositeEx(parent, numColumns, 768);
    }

    public static Composite createCompositeEx(Composite parent, int numColumns, int layoutMode) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(numColumns, true));
        composite.setLayoutData((Object)new GridData(layoutMode));
        return composite;
    }

    public static Composite createCompositeSeparator(Composite parent, Color color, int preferedHeight) {
        Composite separator = ControlFactory.createComposite(parent, 1);
        GridData gd = (GridData)separator.getLayoutData();
        gd.heightHint = -1 == preferedHeight ? 2 : preferedHeight;
        separator.setLayoutData((Object)gd);
        separator.setBackground(color);
        return separator;
    }

    public static Label createSeparator(Composite parent, int nCols) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = nCols;
        separator.setLayoutData((Object)data);
        return separator;
    }

    public static Label createLabel(Composite parent, String text, int widthHint, int heightHint, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = widthHint;
        gd.heightHint = heightHint;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static Label createLabel(Composite parent, String text) {
        return ControlFactory.createLabel(parent, text, -1, -1, 16384);
    }

    public static Label createBoldLabel(Composite parent, String text) {
        Label label = ControlFactory.createLabel(parent, text);
        FontData[] fd = label.getFont().getFontData();
        fd[0].setStyle(1);
        Font font = new Font((Device)Display.getCurrent(), fd[0]);
        label.setFont(font);
        return label;
    }

    public static Label createWrappedLabel(Composite parent, String text, int widthHint, int heightHint) {
        return ControlFactory.createLabel(parent, text, widthHint, heightHint, 16448);
    }

    public static Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener, HyperlinkHandler hyperlinkHandler) {
        Label label = ControlFactory.createLabel(parent, text);
        ControlFactory.turnIntoHyperlink((Control)label, listener, null == hyperlinkHandler ? defaultHyperlinkHandler : hyperlinkHandler);
        return label;
    }

    public static void turnIntoHyperlink(Control control, IHyperlinkListener listener, HyperlinkHandler hyperlinkHandler) {
        hyperlinkHandler.registerHyperlink(control, listener);
    }

    public static Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.setBackground(group.getBackground());
        button.setForeground(group.getForeground());
        return button;
    }

    public static Button createCheckBoxEx(Composite group, String label, int style) {
        Button button = new Button(group, 0x20 | style);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.setBackground(group.getBackground());
        button.setForeground(group.getForeground());
        return button;
    }

    public static Button createRadioButton(Composite group, String label, String value, SelectionListener listener) {
        Button button = new Button(group, 16400);
        button.setText(label);
        button.setData((Object)(null == value ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (null != listener) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Text createTextField(Composite parent) {
        return ControlFactory.createTextField(parent, 2052);
    }

    public static Text createTextField(Composite parent, int style) {
        Text text = new Text(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Group createGroup(Composite parent, String label, int nColumns) {
        Group group = new Group(parent, 0);
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    public static List createList(Composite parent, String strdata, String selData) {
        List list = new List(parent, 4);
        GridData data = new GridData();
        list.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (selData == null) {
            if (list.getItemCount() > 0) {
                list.select(0);
            }
        } else {
            ControlFactory.selectList(list, selData);
        }
        return list;
    }

    public static void selectList(List list, String selData) {
        int n_sel = list.indexOf(selData);
        if (0 > n_sel) {
            n_sel = 0;
        }
        list.select(n_sel);
    }

    public static TableViewer createTableViewer(Composite parent, String[] opt_list, int width, int height, int style) {
        TableViewer listViewer = new TableViewer(parent, 0x800 | style);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        listViewer.getTable().setLayoutData((Object)data);
        if (null != opt_list) {
            listViewer.add((Object[])opt_list);
        }
        return listViewer;
    }

    public static TableViewer createTableViewer(Composite parent, int width, int height, int style, String[] columns, int[] colWidths) {
        TableViewer listViewer = ControlFactory.createTableViewer(parent, null, width, height, style);
        Table table = listViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        return listViewer;
    }

    public static void deactivateCellEditor(TableViewer viewer) {
        if (null == viewer) {
            return;
        }
        CellEditor[] es = viewer.getCellEditors();
        TableItem[] items = viewer.getTable().getSelection();
        if (items.length >= 0) {
            int i = 0;
            while (i < es.length) {
                CellEditor e = es[i];
                if (e.isActivated()) {
                    if (e.isValueValid()) {
                        Object[] properties = viewer.getColumnProperties();
                        Object value = e.getValue();
                        viewer.cancelEditing();
                        viewer.getCellModifier().modify((Object)items[0], (String)properties[i], value);
                        break;
                    }
                    viewer.cancelEditing();
                    break;
                }
                ++i;
            }
        }
    }

    public static CheckboxTableViewer createListViewer(Composite parent, String[] opt_list, int width, int height, int style) {
        Table table = new Table(parent, 2080);
        CheckboxTableViewer listViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(style);
        data.widthHint = width;
        data.heightHint = height;
        listViewer.getTable().setLayoutData((Object)data);
        if (null != opt_list) {
            listViewer.add((Object[])opt_list);
        }
        return listViewer;
    }

    public static CheckboxTableViewer createListViewer(Composite parent, int width, int height, int style, String[] columns, int[] colWidths) {
        CheckboxTableViewer listViewer = ControlFactory.createListViewer(parent, null, width, height, style);
        Table table = listViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column = table.getColumn(0);
        column.setText(columns[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[0], false));
        int i = 1;
        while (i < columns.length) {
            column = new TableColumn(table, 0);
            column.setText(columns[i]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[i], false));
            ++i;
        }
        return listViewer;
    }

    public static CCombo createSelectCCombo(Composite parent, String strdata, String selData) {
        return ControlFactory.createSelectCCombo(parent, strdata, selData, 2056);
    }

    public static CCombo createSelectCCombo(Composite parent, String strdata, String selData, int style) {
        CCombo combo = new CCombo(parent, style);
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            combo.add(st.nextToken());
        }
        if (selData == null || selData.length() == 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            ControlFactory.selectCCombo(combo, selData);
        }
        return combo;
    }

    public static CCombo createSelectCCombo(Composite parent, String[] strdata, String selData) {
        return ControlFactory.createSelectCCombo(parent, strdata, selData, 2060);
    }

    public static CCombo createSelectCCombo(Composite parent, String[] strdata, String selData, int style) {
        CCombo combo = new CCombo(parent, style);
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < strdata.length) {
            combo.add(strdata[i]);
            ++i;
        }
        if (selData == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCCombo(combo, selData);
        }
        return combo;
    }

    public static void selectCCombo(CCombo combo, String selData) {
        int n_sel = combo.indexOf(selData);
        if (0 > n_sel) {
            n_sel = 0;
        }
        combo.select(n_sel);
    }

    public static Combo createSelectCombo(Composite parent, String strdata, String selData) {
        return ControlFactory.createSelectCombo(parent, strdata, selData, 2056);
    }

    public static Combo createSelectCombo(Composite parent, String strdata, String selData, int style) {
        Combo combo = new Combo(parent, style);
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            combo.add(st.nextToken());
        }
        if (selData == null || selData.length() == 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            ControlFactory.selectCombo(combo, selData);
        }
        return combo;
    }

    public static Combo createSelectCombo(Composite parent, String[] strdata, String selData) {
        return ControlFactory.createSelectCombo(parent, strdata, selData, 2060);
    }

    public static Combo createSelectCombo(Composite parent, String[] strdata, String selData, int style) {
        Combo combo = new Combo(parent, style);
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < strdata.length) {
            combo.add(strdata[i]);
            ++i;
        }
        if (selData == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCombo(combo, selData);
        }
        return combo;
    }

    public static void selectCombo(Combo combo, String selData) {
        int n_sel = combo.indexOf(selData);
        if (0 > n_sel) {
            if ((combo.getStyle() & 8) == 0) {
                combo.setText(selData);
                return;
            }
            n_sel = 0;
        }
        combo.select(n_sel);
    }

    public static Shell createDialogShell() {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return new Shell(parent, 2144);
    }

    public static Composite insertSpace(Composite parent, int nSpan, int height) {
        Composite space = ControlFactory.createCompositeSeparator(parent, parent.getBackground(), -1 != height ? height : 5);
        ((GridData)space.getLayoutData()).horizontalSpan = nSpan;
        return space;
    }

    public static MessageBox createDialog(String title, String message, int style) {
        MessageBox box = new MessageBox(ControlFactory.createDialogShell(), style | 0x10000);
        box.setText(title);
        box.setMessage(message);
        return box;
    }

    public static MessageBox createYesNoDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 196);
    }

    public static MessageBox createOkDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 34);
    }

    public static MessageBox createOkCancelDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 290);
    }
}

