/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public class CFormattedMemoryBlock
extends CDebugElement
implements IFormattedMemoryBlock {
    private String fAddressExpression;
    private ICDIMemoryBlock fCDIMemoryBlock;
    private int fFormat;
    private int fWordSize;
    private int fNumberOfRows;
    private int fNumberOfColumns;
    private boolean fDisplayAscii = true;
    private char fPaddingChar = (char)46;
    private List fRows = null;

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) {
        super(target);
        this.fCDIMemoryBlock = cdiMemoryBlock;
        this.fAddressExpression = addressExpression;
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fDisplayAscii = false;
        this.fPaddingChar = '\u0000';
    }

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) {
        super(target);
        this.fCDIMemoryBlock = cdiMemoryBlock;
        this.fAddressExpression = addressExpression;
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fDisplayAscii = true;
        this.fPaddingChar = paddingChar;
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public boolean displayASCII() {
        return this.fDisplayAscii;
    }

    public IFormattedMemoryBlockRow[] getRows() {
        if (this.fRows == null) {
            this.fRows = new ArrayList();
            try {
                int offset = 0;
                byte[] bytes = this.getBytes();
                while (offset < bytes.length) {
                    int length = Math.min(this.fWordSize * this.fNumberOfColumns, bytes.length - offset);
                    this.fRows.add(new CFormattedMemoryBlockRow(this.getStartAddress() + (long)offset, this.createData(bytes, offset, length), this.createAscii(bytes, offset, length)));
                    offset += length;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return this.fRows.toArray(new IFormattedMemoryBlockRow[this.fRows.size()]);
    }

    public long nextRowAddress() {
        return 0L;
    }

    public long previousRowAddress() {
        return 0L;
    }

    public long nextPageAddress() {
        return 0L;
    }

    public long previousPageAddress() {
        return 0L;
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
    }

    public long getStartAddress() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getStartAddress();
        }
        return 0L;
    }

    public long getLength() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getLength();
        }
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        if (this.fCDIMemoryBlock != null) {
            try {
                return this.fCDIMemoryBlock.getBytes();
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        return new byte[0];
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public char getPaddingCharacter() {
        return this.fPaddingChar;
    }

    public void dispose() {
    }

    public String getAddressExpression() {
        return this.fAddressExpression;
    }

    private String[] createData(byte[] bytes, int offset, int length) {
        ArrayList<String> data = new ArrayList<String>(length / this.getWordSize());
        int i = offset;
        while (i < offset + length) {
            data.add(this.createDataItem(bytes, i, Math.min(length + offset - i, this.getWordSize())));
            i += this.getWordSize();
        }
        return data.toArray(new String[data.size()]);
    }

    private String createDataItem(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        int i = offset;
        while (i < length + offset) {
            sb.append(CDebugUtils.getByteText(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    private String createAscii(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length);
        int i = offset;
        while (i < offset + length) {
            sb.append(Character.isISOControl((char)bytes[i]) || bytes[i] < 0 ? this.getPaddingCharacter() : (char)bytes[i]);
            ++i;
        }
        return sb.toString();
    }

    class CFormattedMemoryBlockRow
    implements IFormattedMemoryBlockRow {
        private long fAddress;
        private String[] fData;
        private String fAscii;

        public CFormattedMemoryBlockRow(long address, String[] data, String ascii) {
            this.fAddress = address;
            this.fData = data;
            this.fAscii = ascii;
        }

        public long getAddress() {
            return this.fAddress;
        }

        public String getASCII() {
            return this.fAscii;
        }

        public String[] getData() {
            return this.fData;
        }
    }
}

