/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CorefileDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    private boolean initializingComboBox = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout(2, false);
        comp.setLayout((Layout)topLayout);
        Label dlabel = new Label(comp, 0);
        dlabel.setText("Debugger:");
        this.fDCombo = new Combo(comp, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CorefileDebuggerTab.super.handleDebuggerChanged();
            }
        });
        Group debuggerGroup = new Group(comp, 16);
        debuggerGroup.setText("Debugger Options");
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        if (this.initializingComboBox) {
            return;
        }
        this.initializingComboBox = true;
        String platform = this.getPlatform(config);
        ICElement ce = this.getContext(config, null);
        String projectPlatform = "local";
        if (ce != null) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(ce.getCProject().getProject());
                projectPlatform = descriptor.getPlatform();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        int x = 0;
        int selndx = -1;
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode("core")) {
                String[] supported = debugConfigs[i].getPlatforms();
                boolean isLocal = platform.equals(projectPlatform);
                int j = 0;
                while (j < supported.length) {
                    if (supported[j].equalsIgnoreCase(projectPlatform) || isLocal && supported[j].equalsIgnoreCase("local")) {
                        this.fDCombo.add(debugConfigs[i].getName());
                        this.fDCombo.setData(Integer.toString(x), (Object)debugConfigs[i]);
                        if (selection.equals(debugConfigs[i].getID())) {
                            selndx = x;
                        }
                        ++x;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (selndx != -1) {
            this.fDCombo.select(selndx);
        }
        this.fDCombo.getParent().layout(true);
        this.initializingComboBox = false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            String id = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, "");
            this.loadDebuggerComboBox(config, id);
        }
        catch (CoreException e) {
            return;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "core");
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            this.setErrorMessage("No debugger available");
            return false;
        }
        return super.isValid(config);
    }

    private boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig;
        String platform = this.getPlatform(config);
        ICElement ce = this.getContext(config, null);
        String projectPlatform = "local";
        if (ce != null) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(ce.getCProject().getProject());
                projectPlatform = descriptor.getPlatform();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((debugConfig = this.getDebugConfig()) == null) {
            return false;
        }
        String[] supported = debugConfig.getPlatforms();
        boolean isLocal = platform.equals(projectPlatform);
        int j = 0;
        while (j < supported.length) {
            if (supported[j].equalsIgnoreCase(projectPlatform) || isLocal && supported[j].equalsIgnoreCase("local")) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }

    public String getName() {
        return "Debugger";
    }
}

