/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.IPainter;
import org.eclipse.cdt.internal.ui.editor.IPositionManager;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.cdt.internal.ui.editor.ProblemAnnotationIterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProblemPainter
implements IPainter,
PaintListener,
IAnnotationModelListener {
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    protected boolean fIsModelChanging = false;
    private Color fColor;
    private ITextEditor fTextEditor;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private List fProblemPositions = new ArrayList();

    public ProblemPainter(ITextEditor textEditor, ISourceViewer sourceViewer) {
        this.fTextEditor = textEditor;
        this.fSourceViewer = sourceViewer;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    private boolean hasProblems() {
        return !this.fProblemPositions.isEmpty();
    }

    protected void enablePainting() {
        if (!this.fIsPainting && this.hasProblems()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    protected void disablePainting(boolean redraw) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw && this.hasProblems()) {
                this.handleDrawRequest(null);
            }
        }
    }

    protected void setModel(IAnnotationModel model) {
        if (this.fModel != model) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this);
            }
        }
        if (this.fProblemPositions != null) {
            this.fProblemPositions.clear();
            if (this.fModel != null) {
                ProblemAnnotationIterator e = new ProblemAnnotationIterator(this.fModel);
                while (e.hasNext()) {
                    IProblemAnnotation pa = (IProblemAnnotation)e.next();
                    if (!pa.isProblem()) continue;
                    Annotation a = (Annotation)pa;
                    Position p = this.fModel.getPosition(a);
                    this.fProblemPositions.add(p);
                }
            }
        }
    }

    public void modelChanged(final IAnnotationModel model) {
        Display d;
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed() && !this.fIsModelChanging && (d = this.fTextWidget.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    ProblemPainter.this.disablePainting(true);
                    try {
                        ProblemPainter.this.fIsModelChanging = true;
                        ProblemPainter.this.setModel(model);
                        Object var2_1 = null;
                        ProblemPainter.this.fIsModelChanging = false;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        ProblemPainter.this.fIsModelChanging = false;
                        throw throwable;
                    }
                    ProblemPainter.this.enablePainting();
                }
            });
        }
    }

    public void setHighlightColor(Color color) {
        this.fColor = color;
    }

    public void dispose() {
        this.fColor = null;
        this.fTextWidget = null;
        this.fModel = null;
        this.fProblemPositions = null;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int offset = region.getOffset();
        int length = region.getLength();
        Iterator e = this.fProblemPositions.iterator();
        while (e.hasNext()) {
            Position p = (Position)e.next();
            if (!p.overlapsWith(offset, length)) continue;
            int p1 = Math.max(offset, p.getOffset());
            int p2 = Math.min(offset + length, p.getOffset() + p.getLength());
            this.draw(gc, p1 - offset, p2 - p1);
        }
    }

    private int[] computePolyline(Point left, Point right, int height) {
        int WIDTH = 4;
        int HEIGHT = 2;
        int leftX = left.x;
        int peeks = (right.x - left.x) / 4;
        int length = (2 * peeks + 1) * 2;
        if (length < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int bottom = left.y + height - 1;
        int top = bottom - 2;
        int i = 0;
        while (i < peeks) {
            int index = 4 * i;
            coordinates[index] = leftX + 4 * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left.x + 4 * peeks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    private void draw(GC gc, int offset, int length) {
        if (gc != null) {
            Point left = this.fTextWidget.getLocationAtOffset(offset);
            Point right = this.fTextWidget.getLocationAtOffset(offset + length);
            gc.setForeground(this.fColor);
            int[] polyline = this.computePolyline(left, right, gc.getFontMetrics().getHeight());
            gc.drawPolyline(polyline);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(redraw);
            this.setModel(null);
        }
    }

    public void paint(int reason) {
        if (!this.fIsActive) {
            this.fIsActive = true;
            IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
            this.setModel(provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput()));
            this.enablePainting();
        }
    }

    public void setPositionManager(IPositionManager manager) {
    }
}

