/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.formatter.CCodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class CFormattingStrategy
implements IFormattingStrategy {
    private String fInitialIndentation;
    private ISourceViewer fViewer;

    public CFormattingStrategy(ISourceViewer viewer) {
        this.fViewer = viewer;
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        CCodeFormatter formatter = new CCodeFormatter();
        return formatter.formatSourceString(content);
    }

    public void formatterStarts(String initialIndentation) {
        this.fInitialIndentation = initialIndentation;
    }

    public void formatterStops() {
    }

    private static String getLineDelimiterFor(IDocument doc) {
        String lineDelim = null;
        try {
            lineDelim = doc.getLineDelimiter(0);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        if (lineDelim == null) {
            String systemDelimiter = System.getProperty("line.separator", "\n");
            String[] lineDelims = doc.getLegalLineDelimiters();
            int i = 0;
            while (i < lineDelims.length) {
                if (lineDelims[i].equals(systemDelimiter)) {
                    lineDelim = systemDelimiter;
                    break;
                }
                ++i;
            }
            if (lineDelim == null) {
                lineDelim = lineDelims.length > 0 ? lineDelims[0] : systemDelimiter;
            }
        }
        return lineDelim;
    }
}

