/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.internal.parser.IStructurizerCallback;
import org.eclipse.cdt.internal.parser.LinePositionInputStream;
import org.eclipse.cdt.internal.parser.ParserCallback;
import org.eclipse.cdt.internal.parser.generated.CPPParser;
import org.eclipse.cdt.internal.parser.generated.ParseException;
import org.eclipse.cdt.internal.parser.generated.TokenMgrError;

public class CStructurizer {
    private static CStructurizer fgStructurizerSingelton = new CStructurizer();
    private CPPParser fParser;

    public static CStructurizer getCStructurizer() {
        return fgStructurizerSingelton;
    }

    private CStructurizer() {
    }

    public synchronized void parse(IStructurizerCallback callback, InputStream inputStream) throws IOException {
        LinePositionInputStream lpiStream = new LinePositionInputStream(inputStream);
        try {
            ParserCallback cb = new ParserCallback(lpiStream, callback);
            if (this.fParser == null) {
                this.fParser = new CPPParser(lpiStream);
            } else {
                CPPParser.ReInit(lpiStream);
            }
            CPPParser.setParserCallback(cb);
            CPPParser.translation_unit();
        }
        catch (TokenMgrError error) {
            callback.reportError(error);
        }
        catch (ParseException e) {
            callback.reportError(e);
        }
    }
}

