/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.elf.ERandomAccessFile;

public class Elf {
    protected ERandomAccessFile efile;
    protected ELFhdr ehdr;
    protected Section[] sections;
    protected Addr2line addr2line;
    protected boolean cppFiltEnabled = true;
    protected CPPFilt cppFilt;
    protected String file;
    protected byte[] section_strtab;
    private int syms = 0;
    private Symbol[] symbols;
    private Symbol[] symtab_symbols;
    private Section symtab_sym;
    private Symbol[] dynsym_symbols;
    private Section dynsym_sym;
    protected String EMPTY_STRING = "";

    protected String string_from_elf_section(Section section, int index) throws IOException {
        byte tmp;
        StringBuffer str = new StringBuffer();
        if ((long)index > section.sh_size) {
            return this.EMPTY_STRING;
        }
        this.efile.seek(section.sh_offset + (long)index);
        while ((tmp = this.efile.readByte()) != 0) {
            str.append((char)tmp);
        }
        return str.toString();
    }

    public PHdr[] getPHdrs() throws IOException {
        if (this.ehdr.e_phnum == 0) {
            return new PHdr[0];
        }
        this.efile.seek(this.ehdr.e_phoff);
        PHdr[] phdrs = new PHdr[this.ehdr.e_phnum];
        int i = 0;
        while (i < this.ehdr.e_phnum) {
            phdrs[i] = new PHdr();
            phdrs[i].p_type = this.efile.readIntE();
            phdrs[i].p_offset = this.efile.readIntE();
            phdrs[i].p_vaddr = this.efile.readIntE();
            phdrs[i].p_paddr = this.efile.readIntE();
            phdrs[i].p_filesz = this.efile.readIntE();
            phdrs[i].p_memsz = this.efile.readIntE();
            phdrs[i].p_flags = this.efile.readIntE();
            phdrs[i].p_align = this.efile.readIntE();
            ++i;
        }
        return phdrs;
    }

    public Dynamic[] getDynamicSections(Section section) throws IOException {
        if (section.sh_type != 6L) {
            return new Dynamic[0];
        }
        ArrayList<Dynamic> dynList = new ArrayList<Dynamic>();
        this.efile.seek(section.sh_offset);
        if (section.sh_entsize == 0L) {
            Dynamic dynEnt = new Dynamic(section, this.efile.readIntE(), this.efile.readIntE());
            dynList.add(dynEnt);
        } else {
            int i = 0;
            while ((long)i < section.sh_size / section.sh_entsize) {
                Dynamic dynEnt = new Dynamic(section, this.efile.readIntE(), this.efile.readIntE());
                if (dynEnt.d_tag == 0L) break;
                dynList.add(dynEnt);
                ++i;
            }
        }
        return dynList.toArray(new Dynamic[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commonSetup(String file, long offset, boolean filton) throws IOException {
        this.cppFiltEnabled = filton;
        this.efile = new ERandomAccessFile(file, "r");
        this.efile.setFileOffset(offset);
        try {
            this.ehdr = new ELFhdr();
            this.file = file;
            Object var6_4 = null;
            if (this.ehdr != null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.ehdr != null) throw throwable;
            this.efile.close();
            throw throwable;
        }
        this.efile.close();
    }

    public Elf(String file, long offset) throws IOException {
        this.commonSetup(file, offset, true);
    }

    public Elf(String file) throws IOException {
        this.commonSetup(file, 0L, true);
    }

    public Elf(String file, long offset, boolean filton) throws IOException {
        this.commonSetup(file, offset, filton);
    }

    public Elf(String file, boolean filton) throws IOException {
        this.commonSetup(file, 0L, filton);
    }

    public boolean cppFilterEnabled() {
        return this.cppFiltEnabled;
    }

    public void setCppFilter(boolean enabled) {
        this.cppFiltEnabled = enabled;
    }

    public ELFhdr getELFhdr() throws IOException {
        return this.ehdr;
    }

    public Attribute getAttributes() throws IOException {
        boolean bSkipElfData = false;
        Attribute attrib = new Attribute();
        switch (this.ehdr.e_type) {
            case 2: {
                attrib.type = 1;
                break;
            }
            case 1: {
                attrib.type = 3;
                break;
            }
            case 3: {
                attrib.type = 2;
            }
        }
        switch (this.ehdr.e_machine) {
            case 3: 
            case 6: {
                attrib.cpu = new String("x86");
                bSkipElfData = true;
                break;
            }
            case 20: {
                attrib.cpu = new String("ppc");
                break;
            }
            case 42: {
                attrib.cpu = new String("sh");
                break;
            }
            case 40: {
                attrib.cpu = new String("arm");
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                attrib.cpu = "mips";
                break;
            }
            case 2: 
            case 18: {
                attrib.cpu = "sparc";
                break;
            }
            default: {
                attrib.cpu = "none";
            }
        }
        if (!bSkipElfData) {
            switch (this.ehdr.e_ident[5]) {
                case 1: {
                    attrib.cpu = attrib.cpu + "le";
                    attrib.isle = true;
                    break;
                }
                case 2: {
                    attrib.cpu = attrib.cpu + "be";
                    attrib.isle = false;
                }
            }
        }
        Section[] sec = this.getSections();
        int i = 0;
        while (i < sec.length) {
            String s = sec[i].toString();
            boolean bl = attrib.bDebug = s.equals(".debug") || s.equals(".stab");
            if (attrib.bDebug) break;
            ++i;
        }
        return attrib;
    }

    public static Attribute getAttributes(String file) throws IOException {
        Elf elf = new Elf(file);
        Attribute attrib = elf.getAttributes();
        elf.dispose();
        return attrib;
    }

    public void dispose() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        if (this.cppFilt != null) {
            this.cppFilt.dispose();
        }
        try {
            this.efile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Section[] getSections(int type) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        ArrayList<Section> slist = new ArrayList<Section>();
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].sh_type == (long)type) {
                slist.add(this.sections[i]);
            }
            ++i;
        }
        return slist.toArray(new Section[0]);
    }

    public Section[] getSections() throws IOException {
        if (this.sections == null) {
            if (this.ehdr.e_shoff == 0L) {
                this.sections = new Section[0];
                return this.sections;
            }
            this.efile.seek(this.ehdr.e_shoff);
            this.sections = new Section[this.ehdr.e_shnum];
            int i = 0;
            while (i < this.ehdr.e_shnum) {
                this.sections[i] = new Section();
                this.sections[i].sh_name = this.efile.readIntE();
                this.sections[i].sh_type = this.efile.readIntE();
                this.sections[i].sh_flags = this.efile.readIntE();
                this.sections[i].sh_addr = this.efile.readIntE();
                this.sections[i].sh_offset = this.efile.readIntE();
                this.sections[i].sh_size = this.efile.readIntE();
                this.sections[i].sh_link = this.efile.readIntE();
                this.sections[i].sh_info = this.efile.readIntE();
                this.sections[i].sh_addralign = this.efile.readIntE();
                this.sections[i].sh_entsize = this.efile.readIntE();
                if (this.sections[i].sh_type == 2L) {
                    this.syms = i;
                }
                if (this.syms == 0) {
                    if (this.sections[i].sh_type == 11L) {
                        this.syms = i;
                    }
                }
                ++i;
            }
        }
        return this.sections;
    }

    private Symbol[] loadSymbolsBySection(Section section) throws IOException {
        int numSyms = 1;
        if (section.sh_entsize != 0L) {
            numSyms = (int)section.sh_size / (int)section.sh_entsize;
        }
        ArrayList<Symbol> symList = new ArrayList<Symbol>(numSyms);
        int c = 0;
        while (c < numSyms) {
            this.efile.seek(section.sh_offset + section.sh_entsize * (long)c);
            Symbol symbol = new Symbol(section);
            symbol.st_name = this.efile.readIntE();
            symbol.st_value = this.efile.readIntE();
            symbol.st_size = this.efile.readIntE();
            symbol.st_info = this.efile.readByte();
            symbol.st_other = this.efile.readByte();
            symbol.st_shndx = this.efile.readShortE();
            if (symbol.st_info != 0) {
                symList.add(symbol);
            }
            ++c;
        }
        Object[] results = symList.toArray(new Symbol[0]);
        Arrays.sort(results);
        return results;
    }

    public void loadSymbols() throws IOException {
        if (this.symbols == null) {
            Section[] section = this.getSections(2);
            if (section.length > 0) {
                this.symtab_sym = section[0];
                this.symtab_symbols = this.loadSymbolsBySection(section[0]);
            } else {
                this.symtab_sym = null;
                this.symtab_symbols = new Symbol[0];
            }
            section = this.getSections(11);
            if (section.length > 0) {
                this.dynsym_sym = section[0];
                this.dynsym_symbols = this.loadSymbolsBySection(section[0]);
            } else {
                this.dynsym_sym = null;
                this.dynsym_symbols = new Symbol[0];
            }
            if (this.symtab_sym != null) {
                this.symbols = this.symtab_symbols;
            } else if (this.dynsym_sym != null) {
                this.symbols = this.dynsym_symbols;
            }
        }
    }

    public Symbol[] getSymbols() {
        return this.symbols;
    }

    public Symbol[] getDynamicSymbols() {
        return this.dynsym_symbols;
    }

    public Symbol[] getSymtabSymbols() {
        return this.symtab_symbols;
    }

    public Symbol getSymbol(long vma) {
        if (this.symbols == null) {
            return null;
        }
        SymbolComparator symbol_comparator = new SymbolComparator();
        int ndx = Arrays.binarySearch(this.symbols, new Long(vma), symbol_comparator);
        if (ndx > 0) {
            return this.symbols[ndx];
        }
        if (ndx == -1) {
            return null;
        }
        ndx = -ndx - 1;
        return this.symbols[ndx - 1];
    }

    public long swapInt(long val) {
        if (this.ehdr.e_ident[5] == 1) {
            short[] tmp = new short[]{(short)(val & 0xFFL), (short)(val >> 8 & 0xFFL), (short)(val >> 16 & 0xFFL), (short)(val >> 24 & 0xFFL)};
            return (tmp[0] << 24) + (tmp[1] << 16) + (tmp[2] << 8) + tmp[3];
        }
        return val;
    }

    public int swapShort(short val) {
        if (this.ehdr.e_ident[5] == 1) {
            short[] tmp = new short[]{(short)(val & 0xFF), (short)(val >> 8 & 0xFF)};
            return (short)((tmp[0] << 8) + tmp[1]);
        }
        return val;
    }

    public String getFilename() {
        return this.file;
    }

    public class Attribute {
        public static final int ELF_TYPE_EXE = 1;
        public static final int ELF_TYPE_SHLIB = 2;
        public static final int ELF_TYPE_OBJ = 3;
        String cpu;
        int type;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }

    public class Dynamic {
        public static final int DT_NULL = 0;
        public static final int DT_NEEDED = 1;
        public static final int DT_PLTRELSZ = 2;
        public static final int DT_PLTGOT = 3;
        public static final int DT_HASH = 4;
        public static final int DT_STRTAB = 5;
        public static final int DT_SYMTAB = 6;
        public static final int DT_RELA = 7;
        public static final int DT_RELASZ = 8;
        public static final int DT_RELAENT = 9;
        public static final int DT_STRSZ = 10;
        public static final int DT_SYMENT = 11;
        public static final int DT_INIT = 12;
        public static final int DT_FINI = 13;
        public static final int DT_SONAME = 14;
        public static final int DT_RPATH = 15;
        public long d_tag;
        public long d_val;
        private Section section;
        private String name;

        protected Dynamic(Section section, long tag, long val) {
            this.section = section;
            this.d_tag = tag;
            this.d_val = val;
        }

        public String toString() {
            if (this.name == null) {
                switch ((int)this.d_tag) {
                    case 1: 
                    case 14: 
                    case 15: {
                        try {
                            Section symstr = Elf.this.sections[(int)this.section.sh_link];
                            this.name = Elf.this.string_from_elf_section(symstr, (int)this.d_val);
                        }
                        catch (IOException e) {
                            this.name = Elf.this.EMPTY_STRING;
                        }
                        break;
                    }
                    default: {
                        this.name = Elf.this.EMPTY_STRING;
                    }
                }
            }
            return this.name;
        }
    }

    public class PHdr {
        public static final int PT_NULL = 0;
        public static final int PT_LOAD = 1;
        public static final int PT_DYNAMIC = 2;
        public static final int PT_INTERP = 3;
        public static final int PT_NOTE = 4;
        public static final int PT_SHLIB = 5;
        public static final int PT_PHDR = 6;
        public static final int PF_X = 1;
        public static final int PF_W = 2;
        public static final int PF_R = 4;
        public long p_type;
        public long p_offset;
        public long p_vaddr;
        public long p_paddr;
        public long p_filesz;
        public long p_memsz;
        public long p_flags;
        public long p_align;
    }

    class SymbolComparator
    implements Comparator {
        long val1;
        long val2;

        SymbolComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Long) {
                this.val1 = (Long)o1;
            } else if (o1 instanceof Symbol) {
                this.val1 = ((Symbol)o1).st_value;
            } else {
                return -1;
            }
            if (o2 instanceof Long) {
                this.val2 = (Long)o2;
            } else if (o2 instanceof Symbol) {
                this.val2 = ((Symbol)o2).st_value;
            } else {
                return -1;
            }
            return this.val1 == this.val2 ? 0 : (this.val1 < this.val2 ? -1 : 1);
        }
    }

    public class Symbol
    implements Comparable {
        public static final int STB_LOCAL = 0;
        public static final int STB_GLOBAL = 1;
        public static final int STB_WEAK = 2;
        public static final int STT_NOTYPE = 0;
        public static final int STT_OBJECT = 1;
        public static final int STT_FUNC = 2;
        public static final int STT_SECTION = 3;
        public static final int STT_FILE = 4;
        public static final int SHN_UNDEF = 0;
        public static final int SHN_LORESERVE = -256;
        public static final int SHN_LOPROC = -256;
        public static final int SHN_HIPROC = -225;
        public static final int SHN_LOOS = -224;
        public static final int SHN_HIOS = -193;
        public static final int SHN_ABS = -15;
        public static final int SHN_COMMON = -14;
        public static final int SHN_XINDEX = -1;
        public static final int SHN_HIRESERVE = -1;
        public long st_name;
        public long st_value;
        public long st_size;
        public short st_info;
        public short st_other;
        public short st_shndx;
        private String name = null;
        private String line = null;
        private String func = null;
        private Section sym_section;

        private String cppFilt(String in) {
            if (Elf.this.cppFiltEnabled) {
                try {
                    if (in.indexOf("__") != -1 || in.indexOf("_._") != -1) {
                        if (Elf.this.cppFilt == null) {
                            Elf.this.cppFilt = new CPPFilt();
                        }
                        return Elf.this.cppFilt.getFunction(in);
                    }
                }
                catch (IOException e) {
                    return in;
                }
            }
            return in;
        }

        public Symbol(Section section) {
            this.sym_section = section;
        }

        public int st_type() {
            return this.st_info & 0xF;
        }

        public int st_bind() {
            return this.st_info >> 4 & 0xF;
        }

        public int compareTo(Object obj) {
            long thisVal = 0L;
            long anotherVal = 0L;
            if (obj instanceof Symbol) {
                Symbol sym = (Symbol)obj;
                thisVal = this.st_value;
                anotherVal = sym.st_value;
            } else if (obj instanceof Long) {
                Long val = (Long)obj;
                anotherVal = val;
                thisVal = this.st_value;
            }
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public String toString() {
            if (this.name == null) {
                try {
                    Section[] sections = Elf.this.getSections();
                    Section symstr = sections[(int)this.sym_section.sh_link];
                    this.name = this.cppFilt(Elf.this.string_from_elf_section(symstr, (int)this.st_name));
                }
                catch (IOException e) {
                    return Elf.this.EMPTY_STRING;
                }
            }
            return this.name;
        }

        public String lineInfo() throws IOException {
            if (this.line == null) {
                if (Elf.this.addr2line == null) {
                    Elf.this.addr2line = new Addr2line(Elf.this.file);
                }
                this.line = Elf.this.addr2line.getLine(this.st_value + 19L);
                this.func = Elf.this.addr2line.getFunction(this.st_value + 19L);
            }
            return this.line;
        }

        public String lineInfo(long vma) throws IOException {
            if (Elf.this.addr2line == null) {
                Elf.this.addr2line = new Addr2line(Elf.this.file);
            }
            return Elf.this.addr2line.getLine(vma);
        }

        public String getFunction() throws IOException {
            if (this.func == null) {
                this.lineInfo();
            }
            return this.func;
        }

        public String getFilename() throws IOException {
            int index1;
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line == null || (index1 = this.line.lastIndexOf(58)) == -1) {
                return null;
            }
            int index2 = this.line.indexOf(58);
            index2 = index1 == index2 ? 0 : --index2;
            return this.line.substring(index2, index1);
        }

        public int getFuncLineNumber() throws IOException {
            int index;
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line == null || (index = this.line.lastIndexOf(58)) == -1) {
                return -1;
            }
            try {
                int lineno = Integer.parseInt(this.line.substring(index + 1));
                return lineno == 0 ? -1 : lineno;
            }
            catch (Exception e) {
                return -1;
            }
        }

        public int getLineNumber(long vma) throws IOException {
            int index;
            String ligne = this.lineInfo(vma);
            if (ligne == null || (index = ligne.lastIndexOf(58)) == -1) {
                return -1;
            }
            try {
                int lineno = Integer.parseInt(ligne.substring(index + 1));
                return lineno == 0 ? -1 : lineno;
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    public class Section {
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHF_WRITE = 1;
        public static final int SHF_ALLOC = 2;
        public static final int SHF_EXECINTR = 4;
        public long sh_name;
        public long sh_type;
        public long sh_flags;
        public long sh_addr;
        public long sh_offset;
        public long sh_size;
        public long sh_link;
        public long sh_info;
        public long sh_addralign;
        public long sh_entsize;

        public byte[] loadSectionData() throws IOException {
            byte[] data = new byte[(int)this.sh_size];
            Elf.this.efile.seek(this.sh_offset);
            Elf.this.efile.read(data);
            return data;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try {
                if (Elf.this.section_strtab == null) {
                    int size = (int)Elf.this.sections[Elf.this.ehdr.e_shstrndx].sh_size;
                    if ((long)size > Elf.this.efile.length()) {
                        return Elf.this.EMPTY_STRING;
                    }
                    Elf.this.section_strtab = new byte[size];
                    Elf.this.efile.seek(Elf.this.sections[Elf.this.ehdr.e_shstrndx].sh_offset);
                    Elf.this.efile.read(Elf.this.section_strtab);
                }
                int str_size = 0;
                if (this.sh_name > this.sh_size || this.sh_name + (long)str_size + 1L > (long)Elf.this.section_strtab.length) {
                    return Elf.this.EMPTY_STRING;
                }
                while (true) {
                    if (Elf.this.section_strtab[(int)this.sh_name + str_size] == 0) {
                        return new String(Elf.this.section_strtab, (int)this.sh_name, str_size);
                    }
                    ++str_size;
                }
            }
            catch (IOException e) {
                return Elf.this.EMPTY_STRING;
            }
        }
    }

    public class ELFhdr {
        public static final int EI_MAG0 = 0;
        public static final int EI_MAG1 = 1;
        public static final int EI_MAG2 = 2;
        public static final int EI_MAG3 = 3;
        public static final int EI_CLASS = 4;
        public static final int EI_DATA = 5;
        public static final int EI_VERSION = 6;
        public static final int EI_PAD = 7;
        public static final int EI_NDENT = 16;
        public static final int ELFCLASSNONE = 0;
        public static final int ELCLASS32 = 1;
        public static final int ELFCLASS64 = 2;
        public static final int ELFDATANONE = 0;
        public static final int ELFDATA2LSB = 1;
        public static final int ELFDATA2MSB = 2;
        public static final int ET_NONE = 0;
        public static final int ET_REL = 1;
        public static final int ET_EXEC = 2;
        public static final int ET_DYN = 3;
        public static final int ET_CORE = 4;
        public static final int ET_LOPROC = 65280;
        public static final int ET_HIPROC = 65535;
        public static final int EM_NONE = 0;
        public static final int EM_M32 = 1;
        public static final int EM_SPARC = 2;
        public static final int EM_386 = 3;
        public static final int EM_68K = 4;
        public static final int EM_88K = 5;
        public static final int EM_486 = 6;
        public static final int EM_860 = 7;
        public static final int EM_MIPS = 8;
        public static final int EM_MIPS_RS3_LE = 10;
        public static final int EM_RS6000 = 11;
        public static final int EM_PA_RSIC = 15;
        public static final int EM_nCUBE = 16;
        public static final int EM_VPP500 = 17;
        public static final int EM_SPARC32PLUS = 18;
        public static final int EM_PPC = 20;
        public static final int EM_ARM = 40;
        public static final int EM_SH = 42;
        public byte[] e_ident = new byte[16];
        public short e_type;
        public short e_machine;
        public long e_version;
        public long e_entry;
        public long e_phoff;
        public long e_shoff;
        public long e_flags;
        public short e_ehsize;
        public short e_phentsize;
        public short e_phnum;
        public short e_shentsize;
        public short e_shnum;
        public short e_shstrndx;

        protected ELFhdr() throws IOException {
            Elf.this.efile.seek(0L);
            Elf.this.efile.readFully(this.e_ident);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException("Not ELF format");
            }
            Elf.this.efile.setEndian(this.e_ident[5] == 1);
            this.e_type = Elf.this.efile.readShortE();
            this.e_machine = Elf.this.efile.readShortE();
            this.e_version = Elf.this.efile.readIntE();
            this.e_entry = Elf.this.efile.readIntE();
            this.e_phoff = Elf.this.efile.readIntE();
            this.e_shoff = Elf.this.efile.readIntE();
            this.e_flags = Elf.this.efile.readIntE();
            this.e_ehsize = Elf.this.efile.readShortE();
            this.e_phentsize = Elf.this.efile.readShortE();
            this.e_phnum = Elf.this.efile.readShortE();
            this.e_shentsize = Elf.this.efile.readShortE();
            this.e_shnum = Elf.this.efile.readShortE();
            this.e_shstrndx = Elf.this.efile.readShortE();
        }
    }
}

