/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBDebugger
implements ICDebugger {
    void initializeLibraries(ILaunchConfiguration config, CSession session) throws CDIException {
        try {
            List p;
            SourceManager mgr = (SourceManager)session.getSourceManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, false);
            if (autolib) {
                mgr.setAutoSolib();
            }
            if ((p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_SOLIB_PATH, new ArrayList(1))).size() > 0) {
                String[] paths = p.toArray(new String[0]);
                mgr.setLibraryPaths(paths);
            }
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
    }

    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            CSession session = (CSession)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toOSString());
            this.initializeLibraries(config, session);
            return session;
        }
        catch (IOException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (MIException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
    }

    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            CSession session = (CSession)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toOSString(), pid, null);
            this.initializeLibraries(config, session);
            return session;
        }
        catch (IOException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (MIException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
    }

    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            CSession session = (CSession)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toOSString(), corefile.toOSString());
            this.initializeLibraries(config, session);
            return session;
        }
        catch (IOException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (MIException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing: " + e.getMessage());
        }
    }
}

