/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;

public class TxThread
extends Thread {
    MISession session;

    public TxThread(MISession s) {
        super("MI TX Thread");
        this.session = s;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        try {
            OutputStream out;
            while ((out = this.session.getChannelOutputStream()) != null) {
                void var1_1;
                Object rxQueue;
                Command cmd = null;
                CommandQueue txQueue = this.session.getTxQueue();
                try {
                    cmd = txQueue.removeCommand();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (cmd == null) continue;
                RxThread rx = this.session.getRxThread();
                if (rx != null && rx.isAlive()) {
                    rxQueue = this.session.getRxQueue();
                    ((CommandQueue)rxQueue).addCommand(cmd);
                } else {
                    rxQueue = cmd;
                    synchronized (rxQueue) {
                        cmd.notifyAll();
                    }
                }
                if (cmd instanceof CLICommand) {
                    this.processCLICommand((CLICommand)cmd);
                }
                String str = cmd.toString();
                if (var1_1 == null) continue;
                var1_1.write(str.getBytes());
                var1_1.flush();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        CommandQueue txQueue = this.session.getTxQueue();
        if (txQueue != null) {
            Command[] cmds = txQueue.clearCommands();
            int i = 0;
            while (i < cmds.length) {
                Command command = cmds[i];
                synchronized (command) {
                    cmds[i].notifyAll();
                }
                ++i;
            }
        }
    }

    void processCLICommand(CLICommand cmd) {
        String operation = cmd.getOperation();
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt")) {
            type = 6;
        } else if (operation.startsWith("fin")) {
            type = 5;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont")) {
            type = 0;
        }
        if (type != -1) {
            this.session.getMIInferior().setRunning();
            MIRunningEvent event = new MIRunningEvent(cmd.getToken(), type);
            this.session.fireEvent(event);
        }
    }
}

