/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.Configuration;
import org.eclipse.cdt.debug.mi.core.cdi.CoreFileConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;

public class CSession
implements ICDISession,
ICDISessionObject {
    Properties props;
    MISession session;
    BreakpointManager breakpointManager;
    EventManager eventManager;
    VariableManager variableManager;
    RegisterManager registerManager;
    MemoryManager memoryManager;
    SignalManager signalManager;
    SourceManager sourceManager;
    ICDIConfiguration configuration;
    CTarget ctarget;

    public CSession(MISession s, boolean attach) {
        this.commonSetup(s);
        this.configuration = new Configuration(s, attach);
    }

    public CSession(MISession s) {
        this.commonSetup(s);
        this.configuration = new CoreFileConfiguration();
    }

    private void commonSetup(MISession s) {
        this.session = s;
        this.props = new Properties();
        this.breakpointManager = new BreakpointManager(this);
        this.eventManager = new EventManager(this);
        s.addObserver(this.eventManager);
        this.variableManager = new VariableManager(this);
        this.registerManager = new RegisterManager(this);
        this.memoryManager = new MemoryManager(this);
        this.signalManager = new SignalManager(this);
        this.sourceManager = new SourceManager(this);
        this.ctarget = new CTarget(this);
    }

    public MISession getMISession() {
        return this.session;
    }

    public CTarget getCTarget() {
        return this.ctarget;
    }

    public String getAttribute(String key) {
        return this.props.getProperty(key);
    }

    public ICDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ICDIEventManager getEventManager() {
        return this.eventManager;
    }

    public ICDIExpressionManager getExpressionManager() {
        return this.variableManager;
    }

    public RegisterManager getRegisterManager() {
        return this.registerManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public ICDIMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ICDISignalManager getSignalManager() {
        return this.signalManager;
    }

    public ICDISourceManager getSourceManager() {
        return this.sourceManager;
    }

    public ICDITarget[] getTargets() {
        return new ICDITarget[]{this.ctarget};
    }

    public ICDITarget getCurrentTarget() {
        return this.ctarget;
    }

    public void setCurrentTarget(ICDITarget target) throws CDIException {
        if (target instanceof CTarget) {
            this.ctarget = (CTarget)target;
            return;
        }
        throw new CDIException("Unkown target");
    }

    public void setAttribute(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void terminate() throws CDIException {
        this.session.terminate();
    }

    public ICDIConfiguration getConfiguration() {
        return this.configuration;
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return new RuntimeOptions(this);
    }

    public ICDISession getSession() {
        return this;
    }

    public void addSearchPaths(String[] dirs) throws CDIException {
        CommandFactory factory = this.session.getCommandFactory();
        MIEnvironmentDirectory dir = factory.createMIEnvironmentDirectory(dirs);
        try {
            this.session.postCommand(dir);
            dir.getMIInfo();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public Process getSessionProcess() throws CDIException {
        return this.session.getSessionProcess();
    }
}

