/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;

public class MemoryBlock
extends CObject
implements ICDIMemoryBlock {
    MIDataReadMemoryInfo mem;
    String expression;
    boolean frozen;

    public MemoryBlock(CTarget target, String exp, MIDataReadMemoryInfo info) {
        super(target);
        this.expression = exp;
        this.mem = info;
        this.frozen = true;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setMIDataReadMemoryInfo(MIDataReadMemoryInfo m) {
        this.mem = m;
    }

    public MIDataReadMemoryInfo getMIDataReadMemoryInfo() {
        return this.mem;
    }

    public boolean contains(Long[] adds) {
        int i = 0;
        while (i < adds.length) {
            if (this.contains(adds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Long addr) {
        long start = this.getStartAddress();
        long length = this.getLength();
        return start <= addr && addr <= start + length;
    }

    public byte[] getBytes() throws CDIException {
        MIMemory[] miMem = this.mem.getMemories();
        ArrayList<Long> aList = new ArrayList<Long>();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            int j = 0;
            while (j < data.length) {
                aList.add(new Long(data[j]));
                ++j;
            }
            ++i;
        }
        byte[] bytes = new byte[aList.size()];
        int i2 = 0;
        while (i2 < aList.size()) {
            Long l = (Long)aList.get(i2);
            bytes[i2] = l.byteValue();
            ++i2;
        }
        return bytes;
    }

    public void refresh() throws CDIException {
        MemoryManager mgr = (MemoryManager)this.getCTarget().getCSession().getMemoryManager();
        mgr.update(this, null);
    }

    public long getLength() {
        return this.mem.getTotalBytes();
    }

    public long getStartAddress() {
        return this.mem.getAddress();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws CDIException {
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new CDIException("Bad Offset");
        }
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Long[] addresses = new Long[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue();
            String value = "0x" + Long.toHexString(l);
            MIDataWriteMemory mem = factory.createMIDataWriteMemory(offset + (long)i, this.expression, 0, 1, value);
            try {
                mi.postCommand(mem);
                MIInfo info = mem.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new CDIException(e.getMessage());
            }
            addresses[i] = new Long(this.getStartAddress() + offset + (long)i);
            ++i;
        }
        MIMemoryChangedEvent change = new MIMemoryChangedEvent(addresses);
        mi.fireEvent(change);
    }
}

