/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public class CDebugUtils {
    public static boolean question(IStatus status, Object source) {
        Boolean result = new Boolean(false);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                result = (Boolean)handler.handleStatus(status, source);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static void info(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void error(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static String toHexAddressString(long address) {
        String addressString = Long.toHexString(address);
        StringBuffer sb = new StringBuffer(10);
        sb.append("0x");
        int i = 0;
        while (i < 8 - addressString.length()) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public static char[] getByteText(byte b) {
        return new char[]{CDebugUtils.charFromByte((byte)(b >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(b & 0xF))};
    }

    public static byte textToByte(char[] text) {
        byte result = 0;
        if (text.length == 2) {
            byte[] bytes = new byte[]{CDebugUtils.charToByte(text[0]), CDebugUtils.charToByte(text[1])};
            result = (byte)((bytes[0] << 4) + bytes[1]);
        }
        return result;
    }

    public static char charFromByte(byte value) {
        if (value >= 0 && value <= 9) {
            return (char)(value + 48);
        }
        if (value >= 10 && value <= 15) {
            return (char)(value - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char ch) {
        if (Character.isDigit(ch)) {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(10 + ch - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] bytes) {
        try {
            return (char)Short.parseShort(new String(bytes), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }
}

