/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIMemoryChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public class CFormattedMemoryBlock
extends CDebugElement
implements IFormattedMemoryBlock,
ICDIEventListener {
    private String fAddressExpression;
    private ICDIMemoryBlock fCDIMemoryBlock;
    private byte[] fBytes = null;
    private int fFormat;
    private int fWordSize;
    private int fNumberOfRows;
    private int fNumberOfColumns;
    private boolean fDisplayAscii = true;
    private char fPaddingChar = (char)46;
    private List fRows = null;
    private Long[] fChangedAddresses = new Long[0];
    private boolean fIsDirty = false;

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) {
        this(target, cdiMemoryBlock, addressExpression, format, wordSize, numberOfRows, numberOfColumns, '\u0000');
    }

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) {
        super(target);
        this.fCDIMemoryBlock = cdiMemoryBlock;
        this.fAddressExpression = addressExpression;
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fDisplayAscii = true;
        this.fPaddingChar = paddingChar;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public boolean displayASCII() {
        return this.getWordSize() == 1 && this.fDisplayAscii;
    }

    public IFormattedMemoryBlockRow[] getRows() {
        if (this.fRows == null) {
            this.fRows = new ArrayList();
            try {
                int offset = 0;
                byte[] bytes = this.getBytes();
                while (bytes != null && offset < bytes.length) {
                    int length = Math.min(this.fWordSize * this.fNumberOfColumns, bytes.length - offset);
                    this.fRows.add(new CFormattedMemoryBlockRow(this.getStartAddress() + (long)offset, this.createData(bytes, offset, length), this.createAscii(bytes, offset, length)));
                    offset += length;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return this.fRows.toArray(new IFormattedMemoryBlockRow[this.fRows.size()]);
    }

    private void resetBytes() {
        this.fBytes = null;
        this.fIsDirty = false;
    }

    private void resetRows() {
        this.fRows = null;
    }

    public long nextRowAddress() {
        return 0L;
    }

    public long previousRowAddress() {
        return 0L;
    }

    public long nextPageAddress() {
        return 0L;
    }

    public long previousPageAddress() {
        return 0L;
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        this.resetRows();
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        this.resetRows();
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fPaddingChar = paddingChar;
    }

    public long getStartAddress() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getStartAddress();
        }
        return 0L;
    }

    public long getLength() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getLength();
        }
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        if (this.fBytes == null && this.fCDIMemoryBlock != null) {
            try {
                this.fBytes = this.fCDIMemoryBlock.getBytes();
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fBytes;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public char getPaddingCharacter() {
        return this.fPaddingChar;
    }

    public void dispose() {
        if (this.fCDIMemoryBlock != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDISession().getMemoryManager().removeBlock(this.fCDIMemoryBlock);
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
            this.fCDIMemoryBlock = null;
        }
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public String getAddressExpression() {
        return this.fAddressExpression;
    }

    private String[] createData(byte[] bytes, int offset, int length) {
        ArrayList<String> data = new ArrayList<String>(length / this.getWordSize());
        int i = offset;
        while (i < offset + length) {
            data.add(this.createDataItem(bytes, i, Math.min(length + offset - i, this.getWordSize())));
            i += this.getWordSize();
        }
        return data.toArray(new String[data.size()]);
    }

    private String createDataItem(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        int i = offset;
        while (i < length + offset) {
            sb.append(CDebugUtils.getByteText(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    private String createAscii(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length);
        int i = offset;
        while (i < offset + length) {
            sb.append(Character.isISOControl((char)bytes[i]) || bytes[i] < 0 ? this.getPaddingCharacter() : (char)bytes[i]);
            ++i;
        }
        return sb.toString();
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDIResumedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            } else if (event instanceof ICDIMemoryChangedEvent && source instanceof ICDIMemoryBlock && source.equals(this.getCDIMemoryBlock())) {
                this.handleChangedEvent((ICDIMemoryChangedEvent)event);
            }
        }
    }

    protected ICDIMemoryBlock getCDIMemoryBlock() {
        return this.fCDIMemoryBlock;
    }

    protected void setCDIMemoryBlock(ICDIMemoryBlock cdiMemoryBlock) {
        this.fCDIMemoryBlock = cdiMemoryBlock;
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.resetChangedAddresses();
        this.fireChangeEvent(512);
    }

    private void handleChangedEvent(ICDIMemoryChangedEvent event) {
        this.resetBytes();
        this.resetRows();
        this.setChangedAddresses(event.getAddresses());
        this.fireChangeEvent(512);
    }

    public Long[] getChangedAddresses() {
        return this.fChangedAddresses;
    }

    protected void setChangedAddresses(Long[] changedAddresses) {
        this.fChangedAddresses = changedAddresses;
    }

    protected void resetChangedAddresses() {
        this.fChangedAddresses = new Long[0];
    }

    public boolean isFrozen() {
        return this.getCDIMemoryBlock().isFrozen();
    }

    public void setFrozen(boolean frozen) {
        this.getCDIMemoryBlock().setFrozen(frozen);
    }

    public void setItemValue(int index, String newValue) throws DebugException {
        byte[] bytes = this.itemToBytes(newValue.toCharArray());
        this.setBytes(index * this.getWordSize(), bytes);
        this.fIsDirty = true;
        this.resetRows();
    }

    private void setBytes(int index, byte[] newBytes) {
        try {
            byte[] bytes = this.getBytes();
            int i = index;
            while (i < index + newBytes.length) {
                bytes[i] = newBytes[i - index];
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    private byte[] itemToBytes(char[] chars) {
        switch (this.getFormat()) {
            case 0: {
                return this.hexItemToBytes(chars);
            }
        }
        return new byte[0];
    }

    private byte[] hexItemToBytes(char[] chars) {
        byte[] result = new byte[chars.length / 2];
        int i = 0;
        while (i < result.length) {
            result[i] = CDebugUtils.textToByte(new char[]{chars[2 * i], chars[2 * i + 1]});
            ++i;
        }
        return result;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    class CFormattedMemoryBlockRow
    implements IFormattedMemoryBlockRow {
        private long fAddress;
        private String[] fData;
        private String fAscii;

        public CFormattedMemoryBlockRow(long address, String[] data, String ascii) {
            this.fAddress = address;
            this.fData = data;
            this.fAscii = ascii;
        }

        public long getAddress() {
            return this.fAddress;
        }

        public String getASCII() {
            return this.fAscii;
        }

        public String[] getData() {
            return this.fData;
        }
    }
}

