/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CProjectSourceLocation
implements ICSourceLocation {
    private IProject fProject;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation;

    public CProjectSourceLocation(IProject project) {
        this.setProject(project);
    }

    public Object findSourceElement(String name) throws CoreException {
        if (this.getProject() != null) {
            File file = new File(name);
            if (file.isAbsolute()) {
                return this.findFileByAbsolutePath(name);
            }
            return this.findFileByRelativePath(name);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation)) {
            return this;
        }
        return null;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private Object findFileByAbsolutePath(String name) {
        Path path = new Path(name);
        return this.findFile((IContainer)this.getProject(), path.toOSString());
    }

    private Object findFileByRelativePath(String fileName) {
        IPath path = this.getProject().getLocation().append(fileName);
        Object result = this.findFileByAbsolutePath(path.toOSString());
        if (result == null) {
            try {
                IResource[] members = this.getProject().members();
                int i = 0;
                while (i < members.length) {
                    if (!(members[i] instanceof IFolder) || (result = this.findFile((IContainer)members[i], (path = members[i].getLocation().append(fileName)).toOSString())) == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return result;
    }

    public IPath[] getPaths() {
        IPath[] result = new IPath[]{};
        if (this.getProject() != null) {
            result = new IPath[]{this.getProject().getLocation()};
        }
        return result;
    }

    private Object findFile(IContainer container, String fileName) {
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                Object result;
                if (members[i] instanceof IFile) {
                    if (members[i].getLocation().toOSString().equals(fileName)) {
                        return members[i];
                    }
                } else if (members[i] instanceof IFolder && fileName.startsWith(members[i].getLocation().toOSString()) && (result = this.findFile((IContainer)members[i], fileName)) != null) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

