/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class CDebugImages {
    private static final String NAME_PREFIX = "org.eclipse.cdt.debug.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.cdt.debug.ui.".length();
    private static URL fgIconBaseURL = null;
    private static final ImageRegistry IMAGE_REGISTRY;
    public static final String IMG_OBJS_BREAKPOINT_INSTALLED = "org.eclipse.cdt.debug.ui.installed_ovr.gif";
    public static final String IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED = "org.eclipse.cdt.debug.ui.installed_ovr_disabled.gif";
    public static final String IMG_OBJS_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.readwrite_obj.gif";
    public static final String IMG_OBJS_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.readwrite_obj_disabled.gif";
    public static final String IMG_OBJS_READ_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.read_obj.gif";
    public static final String IMG_OBJS_READ_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.read_obj_disabled.gif";
    public static final String IMG_OBJS_WRITE_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.write_obj.gif";
    public static final String IMG_OBJS_WRITE_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.write_obj_disabled.gif";
    public static final String IMG_OBJS_VARIABLE_SIMPLE = "org.eclipse.cdt.debug.ui.var_simple.gif";
    public static final String IMG_OBJS_VARIABLE_AGGREGATE = "org.eclipse.cdt.debug.ui.var_aggr.gif";
    public static final String IMG_OBJS_VARIABLE_POINTER = "org.eclipse.cdt.debug.ui.var_pointer.gif";
    public static final String IMG_OBJS_VARIABLE_STRING = "org.eclipse.cdt.debug.ui.var_string.gif";
    public static final String IMG_OBJS_REGISTER_GROUP = "org.eclipse.cdt.debug.ui.registergroup_obj.gif";
    public static final String IMG_OBJS_REGISTER = "org.eclipse.cdt.debug.ui.register_obj.gif";
    public static final String IMG_OBJS_DISASSEMBLY = "org.eclipse.cdt.debug.ui.disassembly_obj.gif";
    public static final String IMG_LCL_TYPE_NAMES = "org.eclipse.cdt.debug.ui.tnames_co.gif";
    public static final String IMG_LCL_CHANGE_REGISTER_VALUE = "org.eclipse.cdt.debug.ui.change_reg_value_co.gif";
    public static final String IMG_LCL_AUTO_REFRESH_MEMORY = "org.eclipse.cdt.debug.ui.autorefresh_mem.gif";
    public static final String IMG_LCL_REFRESH_MEMORY = "org.eclipse.cdt.debug.ui.refresh_mem.gif";
    public static final String IMG_LCL_MEMORY_SAVE = "org.eclipse.cdt.debug.ui.memory_save.gif";
    public static final String IMG_LCL_MEMORY_CLEAR = "org.eclipse.cdt.debug.ui.memory_clear.gif";
    public static final String IMG_LCL_SHOW_ASCII = "org.eclipse.cdt.debug.ui.show_ascii.gif";
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_LCL = "lcl16";
    private static final String T_CTOOL = "ctool16";
    private static final String T_CVIEW = "cview16";
    private static final String T_DTOOL = "dtool16";
    private static final String T_ETOOL = "etool16";
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_INSTALLED;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_INSTALLED_DISABLED;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_READ_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_READ_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_WRITE_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_WRITE_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_SIMPLE;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_AGGREGATE;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_POINTER;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_STRING;
    public static final ImageDescriptor DESC_OBJS_REGISTER_GROUP;
    public static final ImageDescriptor DESC_OBJS_REGISTER;
    public static final ImageDescriptor DESC_OBJS_DISASSEMBLY;

    public static Image get(String key) {
        return IMAGE_REGISTRY.get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        CDebugImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        CDebugImages.setImageDescriptors(action, T_LCL, iconName);
    }

    static ImageRegistry getImageRegistry() {
        return IMAGE_REGISTRY;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        try {
            id = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        action.setImageDescriptor(CDebugImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            IMAGE_REGISTRY.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }

    static {
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(CDebugUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        IMAGE_REGISTRY = new ImageRegistry(CDebugUIPlugin.getStandardDisplay());
        DESC_OBJS_BREAKPOINT_INSTALLED = CDebugImages.createManaged(T_OVR, IMG_OBJS_BREAKPOINT_INSTALLED);
        DESC_OBJS_BREAKPOINT_INSTALLED_DISABLED = CDebugImages.createManaged(T_OVR, IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED);
        DESC_OBJS_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_ENABLED);
        DESC_OBJS_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_DISABLED);
        DESC_OBJS_READ_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_READ_WATCHPOINT_ENABLED);
        DESC_OBJS_READ_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_READ_WATCHPOINT_DISABLED);
        DESC_OBJS_WRITE_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WRITE_WATCHPOINT_ENABLED);
        DESC_OBJS_WRITE_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WRITE_WATCHPOINT_DISABLED);
        DESC_OBJS_VARIABLE_SIMPLE = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_SIMPLE);
        DESC_OBJS_VARIABLE_AGGREGATE = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_AGGREGATE);
        DESC_OBJS_VARIABLE_POINTER = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_POINTER);
        DESC_OBJS_VARIABLE_STRING = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_STRING);
        DESC_OBJS_REGISTER_GROUP = CDebugImages.createManaged(T_OBJ, IMG_OBJS_REGISTER_GROUP);
        DESC_OBJS_REGISTER = CDebugImages.createManaged(T_OBJ, IMG_OBJS_REGISTER);
        DESC_OBJS_DISASSEMBLY = CDebugImages.createManaged(T_OBJ, IMG_OBJS_DISASSEMBLY);
    }
}

