/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.ICBreakpoint;
import org.eclipse.cdt.debug.internal.ui.actions.CBreakpointPreferencePage;
import org.eclipse.cdt.debug.internal.ui.actions.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CBreakpointPropertiesDialog
extends Dialog
implements IPreferencePageContainer {
    private Composite fTitleArea;
    private Label fTitleImage;
    private CLabel fMessageLabel;
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private Image fErrorMsgImage;
    private CBreakpointPreferencePage fPage;
    private Button fOkButton;
    protected static final String PREF_DLG_TITLE_IMG = "breakpoint_preference_dialog_title_image";
    protected static final String PREF_DLG_IMG_TITLE_ERROR = "breakpoint_preference_dialog_title_error_image";
    private Composite fPageContainer;
    private Point fMinimumPageSize = new Point(200, 200);
    private ICBreakpoint fBreakpoint;
    private CBreakpointPreferenceStore fCBreakpointPreferenceStore;
    static /* synthetic */ Class class$org$eclipse$jface$preference$PreferenceDialog;
    static /* synthetic */ Class class$org$eclipse$jface$dialogs$Dialog;

    public CBreakpointPropertiesDialog(Shell parentShell, ICBreakpoint breakpoint) {
        super(parentShell);
        this.setBreakpoint(breakpoint);
        this.fCBreakpointPreferenceStore = new CBreakpointPreferenceStore();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fCBreakpointPreferenceStore;
    }

    public void updateButtons() {
        if (this.fOkButton != null) {
            this.fOkButton.setEnabled(this.fPage.isValid());
        }
    }

    public void updateMessage() {
        String pageMessage = this.fPage.getMessage();
        String pageErrorMessage = this.fPage.getErrorMessage();
        if (pageMessage == null && pageErrorMessage == null) {
            this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.fMessageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (pageMessage == null) {
            this.setMessage(this.fPage.getTitle());
        } else {
            this.setMessage(pageMessage);
        }
        this.setErrorMessage(pageErrorMessage);
    }

    public void updateTitle() {
        this.setTitle(this.fPage.getTitle());
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            if (this.fMessageLabel.getImage() != null) {
                this.fMessageLabel.setBackground(this.fNormalMsgAreaBackground);
                this.fMessageLabel.setImage(null);
                this.fTitleImage.setImage(CDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
                this.fTitleArea.layout(true);
            }
            this.setMessage(this.fMessage);
        } else {
            this.fMessageLabel.setText(errorMessage);
            if (this.fMessageLabel.getImage() == null) {
                if (this.fErrorMsgImage == null) {
                    this.fErrorMsgImage = CDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.fNormalMsgAreaBackground = this.fMessageLabel.getBackground();
                this.fMessageLabel.setBackground(JFaceColors.getErrorBackground((Display)this.fMessageLabel.getDisplay()));
                this.fMessageLabel.setImage(this.fErrorMsgImage);
                this.fTitleImage.setImage(null);
                this.fTitleArea.layout(true);
            }
        }
    }

    public void setMessage(String newMessage) {
        this.fMessage = newMessage;
        if (this.fMessage == null) {
            this.fMessage = "";
        }
        if (this.fMessageLabel.getImage() == null) {
            this.fMessageLabel.setText(this.fMessage);
        }
    }

    public void setTitle(String title) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    protected void okPressed() {
        final ArrayList changedProperties = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        this.fPage.performOk();
        this.setBreakpointProperties(changedProperties);
        super.okPressed();
    }

    protected void setBreakpointProperties(final List changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICBreakpoint breakpoint = CBreakpointPropertiesDialog.this.getBreakpoint();
                Iterator changed = changedProperties.iterator();
                while (changed.hasNext()) {
                    String property = (String)changed.next();
                    if (property.equals("IGNORE_COUNT")) {
                        breakpoint.setIgnoreCount(CBreakpointPropertiesDialog.this.getPreferenceStore().getInt("IGNORE_COUNT"));
                        continue;
                    }
                    if (!property.equals("CONDITION")) continue;
                    breakpoint.setCondition(CBreakpointPropertiesDialog.this.getPreferenceStore().getString("CONDITION"));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    protected ICBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(ICBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createTitleArea(titleComposite);
        Label titleBarSeparator = new Label(titleComposite, 258);
        GridData gd = new GridData(768);
        titleBarSeparator.setLayoutData((Object)gd);
        this.fPageContainer = this.createPageContainer(composite, 2);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        this.fPageContainer.setFont(parent.getFont());
        this.fPage = new CBreakpointPreferencePage(this.getBreakpoint());
        this.fPage.setContainer(this);
        this.fPage.createControl(this.fPageContainer);
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        this.fTitleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color bg = JFaceColors.getBannerBackground((Display)display);
        Color fg = JFaceColors.getBannerForeground((Display)display);
        GridData layoutData = new GridData(1808);
        this.fTitleArea.setLayout((Layout)layout);
        this.fTitleArea.setLayoutData((Object)layoutData);
        this.fTitleArea.setBackground(bg);
        this.fMessageLabel = new CLabel(this.fTitleArea, 16384);
        this.fMessageLabel.setBackground(bg);
        this.fMessageLabel.setForeground(fg);
        this.fMessageLabel.setText(" ");
        this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty()) || "org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    CBreakpointPropertiesDialog.this.updateMessage();
                }
            }
        };
        this.fMessageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        this.fMessageLabel.setLayoutData((Object)gd);
        this.fTitleImage = new Label(this.fTitleArea, 16384);
        this.fTitleImage.setBackground(bg);
        this.fTitleImage.setImage(CDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.fTitleImage.setLayoutData((Object)gd);
        return this.fTitleArea;
    }

    private Composite createPageContainer(Composite parent, int numColumns) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new PageLayout());
        return result;
    }

    public void setMinimumPageSize(Point size) {
        this.fMinimumPageSize.x = size.x;
        this.fMinimumPageSize.y = size.y;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getMinimumPageSize() {
        return this.fMinimumPageSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageRegistry reg = CDebugUIPlugin.getDefault().getImageRegistry();
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile((Class)(class$org$eclipse$jface$preference$PreferenceDialog == null ? (class$org$eclipse$jface$preference$PreferenceDialog = CBreakpointPropertiesDialog.class$("org.eclipse.jface.preference.PreferenceDialog")) : class$org$eclipse$jface$preference$PreferenceDialog), (String)"images/pref_dialog_title.gif"));
        reg.put(PREF_DLG_IMG_TITLE_ERROR, ImageDescriptor.createFromFile((Class)(class$org$eclipse$jface$dialogs$Dialog == null ? (class$org$eclipse$jface$dialogs$Dialog = CBreakpointPropertiesDialog.class$("org.eclipse.jface.dialogs.Dialog")) : class$org$eclipse$jface$dialogs$Dialog), (String)"images/message_error.gif"));
    }

    private class PageLayout
    extends Layout {
        private PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = CBreakpointPropertiesDialog.this.getMinimumPageSize().x;
            int y = CBreakpointPropertiesDialog.this.getMinimumPageSize().y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

