/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener {
    private HashMap fConsoleDocumentMap;
    ListenerList listeners = new ListenerList(1);

    public BuildConsoleManager() {
        this.fConsoleDocumentMap = new HashMap();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fConsoleDocumentMap == null) {
            return;
        }
        IResource resource = event.getResource();
        if (event.getType() == 4 && resource.getType() == 4) {
            this.fConsoleDocumentMap.remove(resource);
        }
    }

    public void shutdown() {
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() {
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private BuildConsole getBuildConsole(IProject project) {
        BuildConsole console = (BuildConsole)((Object)this.fConsoleDocumentMap.get(project));
        if (console == null) {
            console = new BuildConsole();
            this.fConsoleDocumentMap.put(project, console);
        }
        return console;
    }

    public IConsole getConsole(IProject project) {
        return this.getBuildConsole(project);
    }

    public IDocument getConsoleDocument(IProject project) {
        return this.getBuildConsole(project).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConsoleListener(IBuildConsoleListener listener) {
        this.listeners.remove((Object)listener);
    }

    private class BuildConsole
    extends ConsoleOutputStream
    implements IConsole {
        protected IDocument fDocument = new Document();

        public void start(IProject project) {
            Object[] list;
            if (CPluginPreferencePage.isClearBuildConsole()) {
                this.clear();
            }
            if ((list = BuildConsoleManager.this.listeners.getListeners()).length > 0) {
                int i = 0;
                while (i < list.length) {
                    IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                    ConsoleEvent event = new ConsoleEvent(project, 1);
                    listener.consoleChange(event);
                    ++i;
                }
            }
        }

        public void clear() {
            super.clear();
            Display.getDefault().syncExec(new Runnable(this){
                private final /* synthetic */ BuildConsole this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.fDocument.set("");
                }
            });
        }

        public ConsoleOutputStream getOutputStream() {
            return this;
        }

        public IDocument getDocument() {
            return this.fDocument;
        }

        public synchronized void flush() throws IOException {
            super.flush();
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ BuildConsole this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (CPluginPreferencePage.isConsoleOnTop()) {
                        this.this$1.bringConsoleOnTop();
                    }
                    try {
                        int len = this.this$1.fDocument.getLength();
                        this.this$1.fDocument.replace(len, 0, this.this$1.readBuffer());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }

        void bringConsoleOnTop() {
            IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                try {
                    IViewPart cBuild = page.findView("org.eclipse.cdt.ui.BuildConsoleView");
                    if (cBuild == null) {
                        if (CPluginPreferencePage.isAutoOpenConsole()) {
                            IWorkbenchPart activePart = page.getActivePart();
                            cBuild = page.showView("org.eclipse.cdt.ui.BuildConsoleView");
                            page.activate(activePart);
                        }
                    } else {
                        page.bringToTop((IWorkbenchPart)cBuild);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }
}

