/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SettingsBlock
implements IWizardTab {
    private static final String PREFIX = "SettingsBlock";
    private static final String LABEL = "SettingsBlock.label";
    private static final String KEEP_GOING = "SettingsBlock.keepOnGoing";
    private static final String STOP_ERROR = "SettingsBlock.stopOnError";
    private static final String MAKE_OPTION = "SettingsBlock.makeOption.label";
    private static final String MAKE_USE_DEFAULT = "SettingsBlock.makeOption.use_default";
    private static final String MAKE_BUILD_CMD = "SettingsBlock.makeOption.build_cmd";
    private static final String KEEP_ARG = "keep";
    private static final String STOP_ARG = "stop";
    protected RadioButtonsArea radioButtons;
    protected Button defButton;
    protected Text cmdText;
    private boolean stopOnError;
    private boolean useDefaultBuildCmd;
    private boolean defaultSelectionMade;
    private String buildCmd;
    IValidation page;

    public SettingsBlock(IValidation valid) {
        this(valid, null);
    }

    public SettingsBlock(IValidation valid, IProject project) {
        block5: {
            this.defaultSelectionMade = false;
            if (project != null) {
                try {
                    CProjectNature nature = (CProjectNature)project.getNature("org.eclipse.cdt.core.cnature");
                    if (nature == null) break block5;
                    this.stopOnError = nature.isStopOnError();
                    this.useDefaultBuildCmd = nature.isDefaultBuildCmd();
                    if (!this.useDefaultBuildCmd) {
                        this.buildCmd = nature.getBuildCommand().toOSString();
                        this.buildCmd = this.buildCmd + " " + nature.getFullBuildArguments();
                    }
                }
                catch (CoreException coreException) {}
            } else {
                this.stopOnError = false;
                this.useDefaultBuildCmd = true;
            }
        }
        this.page = valid;
    }

    public String getLabel() {
        return CUIPlugin.getResourceString(LABEL);
    }

    public Image getImage() {
        return null;
    }

    public Composite getControl(Composite parent) {
        Composite composite = ControlFactory.createComposite(parent, 1);
        String[][] radios = new String[][]{{CUIPlugin.getResourceString(STOP_ERROR), STOP_ARG}, {CUIPlugin.getResourceString(KEEP_GOING), KEEP_ARG}};
        this.radioButtons = new RadioButtonsArea(composite, CUIPlugin.getResourceString(LABEL), 1, radios);
        Group mgroup = ControlFactory.createGroup(composite, CUIPlugin.getResourceString(MAKE_OPTION), 1);
        this.defButton = ControlFactory.createCheckBox((Composite)mgroup, CUIPlugin.getResourceString(MAKE_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsBlock.this.defButton.getSelection()) {
                    SettingsBlock.this.cmdText.setEnabled(false);
                    SettingsBlock.this.radioButtons.setEnabled(true);
                    if (null != SettingsBlock.this.page) {
                        SettingsBlock.this.page.setComplete(SettingsBlock.this.isValid());
                    }
                } else {
                    SettingsBlock.this.cmdText.setEnabled(true);
                    SettingsBlock.this.radioButtons.setEnabled(false);
                    if (null != SettingsBlock.this.page) {
                        SettingsBlock.this.page.setComplete(SettingsBlock.this.isValid());
                    }
                }
            }
        });
        Composite cmdComp = new Composite((Composite)mgroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        cmdComp.setLayout((Layout)layout);
        cmdComp.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel(cmdComp, CUIPlugin.getResourceString(MAKE_BUILD_CMD));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.cmdText = ControlFactory.createTextField(cmdComp, 2052);
        ((GridData)this.cmdText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.cmdText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.cmdText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SettingsBlock.this.page.setComplete(SettingsBlock.this.isValid());
            }
        });
        if (this.buildCmd != null) {
            this.cmdText.setText(this.buildCmd);
        }
        if (this.useDefaultBuildCmd) {
            this.cmdText.setEnabled(false);
        } else {
            this.radioButtons.setEnabled(false);
        }
        return composite;
    }

    public boolean isValid() {
        String cmd;
        return this.defButton.getSelection() || (cmd = this.getBuildLine()) != null && cmd.length() != 0;
    }

    public void setVisible(boolean visible) {
        if (!this.defaultSelectionMade) {
            if (this.stopOnError) {
                this.radioButtons.setSelectValue(STOP_ARG);
            } else {
                this.radioButtons.setSelectValue(KEEP_ARG);
            }
            this.defButton.setSelection(this.useDefaultBuildCmd);
            this.defaultSelectionMade = true;
        }
    }

    public void doRun(IProject project, IProgressMonitor monitor) {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Settings", 1);
            CProjectNature nature = (CProjectNature)project.getNature("org.eclipse.cdt.core.cnature");
            if (nature != null) {
                nature.setStopOnError(this.isStopOnError());
                nature.setBuildCommandOverride(this.useDefaultBuildCmd());
                if (!this.useDefaultBuildCmd()) {
                    String bldLine = this.getBuildLine();
                    int start = bldLine.indexOf(32);
                    Path path = start == -1 ? new Path(bldLine) : new Path(bldLine.substring(0, start));
                    nature.setBuildCommand((IPath)path, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    String args = "";
                    if (start != -1) {
                        args = bldLine.substring(start + 1);
                    }
                    nature.setFullBuildArguments(args, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private boolean isStopOnError() {
        if (this.defaultSelectionMade && this.radioButtons != null) {
            return this.radioButtons.getSelectedValue().equals(STOP_ARG);
        }
        return this.stopOnError;
    }

    private boolean useDefaultBuildCmd() {
        if (this.defaultSelectionMade && this.defButton != null) {
            return this.defButton.getSelection();
        }
        return this.useDefaultBuildCmd;
    }

    private String getBuildLine() {
        String cmd;
        if (this.cmdText != null && (cmd = this.cmdText.getText()) != null) {
            return cmd.trim();
        }
        return null;
    }
}

