/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LocalCLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Launching Local C Application", -1);
        if (monitor.isCanceled()) {
            return;
        }
        IPath projectPath = this.verifyProgramFile(config);
        String[] arguments = this.getProgramArgumentsArray(config);
        ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
        command.add(projectPath.toOSString());
        command.addAll(Arrays.asList(arguments));
        String[] commandArray = command.toArray(new String[command.size()]);
        if (mode.equals("debug")) {
            IProcess debuggerProcess = null;
            ICDebugConfiguration debugConfig = this.getDebugConfig(config);
            IFile exe = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(projectPath);
            ICDISession dsession = null;
            try {
                String debugMode = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "run");
                if (debugMode.equals("run")) {
                    dsession = debugConfig.getDebugger().createLaunchSession(config, exe);
                    ICDIRuntimeOptions opt = dsession.getRuntimeOptions();
                    opt.setArguments(this.getProgramArgumentsArray(config));
                    File wd = this.getWorkingDir(config);
                    if (wd != null) {
                        opt.setWorkingDirectory(wd.toString());
                    }
                    opt.setEnvironment(this.getEnvironmentProperty(config));
                    ICDITarget dtarget = dsession.getTargets()[0];
                    Process process = dtarget.getProcess();
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
                    Process debugger = dsession.getSessionProcess();
                    if (debugger != null) {
                        debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)"Debug Console");
                        launch.removeProcess(debuggerProcess);
                    }
                    boolean stopInMain = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, false);
                    CDebugModel.newDebugTarget((ILaunch)launch, (ICDITarget)dsession.getCurrentTarget(), (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IProcess)debuggerProcess, (IFile)exe, (boolean)true, (boolean)false, (boolean)stopInMain);
                } else if (debugMode.equals("attach")) {
                    Process debugger;
                    int pid = this.getProcessID();
                    if (pid == -1) {
                        this.cancel("No Process ID selected", 107);
                    }
                    if ((debugger = (dsession = debugConfig.getDebugger().createAttachSession(config, exe, pid)).getSessionProcess()) != null) {
                        debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)"Debug Console");
                        launch.removeProcess(debuggerProcess);
                    }
                    CDebugModel.newAttachDebugTarget((ILaunch)launch, (ICDITarget)dsession.getCurrentTarget(), (String)this.renderTargetLabel(debugConfig), (IProcess)debuggerProcess, (IFile)exe);
                }
            }
            catch (CDIException e) {
                this.abort("Failed Launching CDI Debugger", e, 150);
            }
        } else {
            Process process = this.exec(commandArray, this.getEnvironmentArray(config), this.getWorkingDir(config));
            DebugPlugin.getDefault();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
        }
        monitor.done();
    }

    private int getProcessID() throws CoreException {
        final Shell shell = LaunchUIPlugin.getShell();
        final int[] pid = new int[]{-1};
        if (shell == null) {
            this.abort("No Shell availible in Launch", null, 150);
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String getText(Object element) {
                        IProcessInfo info = (IProcessInfo)element;
                        return info.getPid() + " " + info.getName();
                    }
                });
                dialog.setTitle("Select Process");
                dialog.setMessage("Select a Process to attach debugger to:");
                IProcessList plist = CCorePlugin.getDefault().getProcessList();
                if (plist == null) {
                    MessageDialog.openError((Shell)shell, (String)"CDT Launch Error", (String)"Current platform does not support listing processes");
                    return;
                }
                dialog.setElements((Object[])plist.getProcessList());
                if (dialog.open() == 0) {
                    IProcessInfo info = (IProcessInfo)dialog.getFirstResult();
                    pid[0] = info.getPid();
                }
            }
        });
        return pid[0];
    }

    protected Process exec(String[] cmdLine, String[] envp, File workingDirectory) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory);
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort("Error starting process", e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, "Eclipse runtime does not support working directory", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, envp, null);
            }
        }
        return p;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

