/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIFunctionFinishedEvent
extends MIStoppedEvent {
    String gdbResult = "";
    String returnValue = "";
    int threadId;
    MIFrame frame;
    MIExecAsyncOutput exec;
    MIResultRecord rr;

    public MIFunctionFinishedEvent(MIExecAsyncOutput async) {
        super(async.getToken());
        this.exec = async;
        this.parse();
    }

    public MIFunctionFinishedEvent(MIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public String getGDBResultVar() {
        return this.gdbResult;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("gdb-result-var=" + this.gdbResult + "\n");
        buffer.append("return-value=" + this.returnValue + "\n");
        buffer.append("thread-id=").append(this.threadId).append('\n');
        buffer.append(this.frame.toString());
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("gdb-result-var")) {
                    this.gdbResult = str;
                } else if (var.equals("return-value")) {
                    this.returnValue = str;
                } else if (var.equals("thread-id")) {
                    try {
                        this.threadId = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

