/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.IRunToLine;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RunToLineRulerAction
extends Action
implements IUpdate,
ISelectionListener,
INullSelectionListener {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IDebugTarget fDebugTarget = null;

    public RunToLineRulerAction(IVerticalRulerInfo info, ITextEditor editor) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText("Run To Line");
        this.initializeDebugTarget();
        this.update();
    }

    public void update() {
        boolean enabled = false;
        IResource resource = this.getResource();
        int lineNumber = this.getLineNumber();
        IDocumentProvider provider = this.getTextEditor().getDocumentProvider();
        IDocument doc = provider.getDocument((Object)this.getTextEditor().getEditorInput());
        if (resource != null && lineNumber <= doc.getNumberOfLines() && lineNumber > 0) {
            enabled = this.getDebugTarget() != null && ((IRunToLine)this.getDebugTarget()).canRunToLine(resource, lineNumber);
        }
        this.setEnabled(enabled);
    }

    public void run() {
        this.runToLine(this.getResource(), this.getLineNumber());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && target1 instanceof IRunToLine) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && target instanceof IRunToLine) {
            this.setDebugTarget(target);
        }
    }

    protected void setDebugTarget(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IResource getResource() {
        IEditorInput input = this.getTextEditor().getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected int getLineNumber() {
        return this.getInfo().getLineOfLastMouseButtonActivity() + 1;
    }

    protected void runToLine(IResource resource, int lineNumber) {
        if (!((IRunToLine)this.getDebugTarget()).canRunToLine(resource, lineNumber)) {
            this.getTextEditor().getSite().getShell().getDisplay().beep();
            return;
        }
        try {
            ((IRunToLine)this.getDebugTarget()).runToLine(resource, lineNumber);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), e);
        }
    }
}

