/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CFile;
import org.eclipse.cdt.internal.core.model.CFileInfo;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

class ArchiveInfo
extends CFileInfo {
    public ArchiveInfo(CElement element) {
        super(element);
    }

    public ICElement[] getChildren() {
        this.init();
        return super.getChildren();
    }

    public void init() {
        if (this.hasChanged()) {
            this.removeChildren();
            this.loadInfo();
        }
    }

    public boolean isArchive() {
        return true;
    }

    protected void loadInfo() {
        IPath location = ((CFile)this.getElement()).getLocation();
        IFile file = ((CFile)this.getElement()).getFile();
        try {
            AR ar = new AR(location.toOSString());
            AR.ARHeader[] header = ar.getHeaders();
            int i = 0;
            while (i < header.length) {
                ElfHelper helper = new ElfHelper(header[i].getElf());
                Binary binary = new Binary(this.getElement(), file, header[i].getObjectName()){

                    public IResource getCorrespondingResource() {
                        return null;
                    }
                };
                ((BinaryInfo)binary.getElementInfo()).elfHelper = helper;
                binary.getChildren();
                ((BinaryInfo)binary.getElementInfo()).elfHelper = null;
                helper.dispose();
                this.addChild(binary);
                ++i;
            }
            ar.dispose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

