/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.sourcelookup.DefaultSourceLocator;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ISourceLocator;

public abstract class AbstractCLaunchDelegate
implements ILaunchConfigurationDelegate {
    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String[] getEnvironmentArray(ILaunchConfiguration config) {
        Map env = null;
        try {
            env = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (env == null) {
            return new String[0];
        }
        String[] array = new String[env.size()];
        Iterator entries = env.entrySet().iterator();
        int i = 0;
        while (entries.hasNext() && i < array.length) {
            Map.Entry entry = entries.next();
            array[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
            ++i;
        }
        return array;
    }

    protected Properties getEnvironmentProperty(ILaunchConfiguration config) {
        Properties prop = new Properties();
        Map env = null;
        try {
            env = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (env == null) {
            return prop;
        }
        Iterator entries = env.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return prop;
    }

    protected Properties getDefaultEnvironment() {
        return EnvironmentReader.getEnvVars();
    }

    protected Properties expandEnvironment(ILaunchConfiguration config) {
        return this.expandEnvironment(this.getEnvironmentProperty(config));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Properties expandEnvironment(Properties props) {
        block13: {
            Enumeration<?> names = props.propertyNames();
            if (names == null) break block13;
            while (names.hasMoreElements()) {
                int prev;
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (value == null || value.indexOf(36) == -1) continue;
                StringBuffer sb = new StringBuffer();
                StringBuffer param = new StringBuffer();
                int ch = prev = 10;
                boolean inMacro = false;
                boolean inSingleQuote = false;
                int i = 0;
                while (i < value.length()) {
                    block14: {
                        ch = value.charAt(i);
                        switch (ch) {
                            case 39: {
                                if (prev == 92) break;
                                inSingleQuote = !inSingleQuote;
                                break;
                            }
                            case 36: {
                                char c;
                                if (inSingleQuote || prev == 92 || i >= value.length() || value.indexOf(125, i) <= 0 || (c = value.charAt(i + 1)) != '{') break;
                                param.setLength(0);
                                inMacro = true;
                                prev = ch;
                                break block14;
                            }
                            case 125: {
                                Properties def;
                                if (!inMacro) break;
                                inMacro = false;
                                String v = null;
                                String p = param.toString();
                                if (!p.equals(key)) {
                                    v = props.getProperty(p);
                                }
                                if (v == null && (def = this.getDefaultEnvironment()) != null) {
                                    v = def.getProperty(p);
                                }
                                if (v != null) {
                                    sb.append(v);
                                }
                                param.setLength(0);
                                prev = ch;
                                break block14;
                            }
                        }
                        if (!inMacro) {
                            sb.append((char)ch);
                        } else if (ch != 123 || prev != 36) {
                            param.append((char)ch);
                        }
                        prev = ch == 92 && prev == 92 ? 10 : ch;
                    }
                    ++i;
                }
                props.setProperty(key, sb.toString());
            }
        }
        return props;
    }

    public File getWorkingDir(ILaunchConfiguration configuration) throws CoreException {
        return this.getWorkingDirectory(configuration);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String path = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, (String)null);
        if (path != null) {
            return new Path(path);
        }
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        String newMessage = message;
        if (exception != null) {
            newMessage = message + " : " + exception.getLocalizedMessage();
        }
        throw new CoreException((IStatus)new Status(4, this.getPluginID(), code, newMessage, exception));
    }

    protected void cancel(String message, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(0, this.getPluginID(), code, message, null));
    }

    protected abstract String getPluginID();

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = AbstractCLaunchDelegate.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_NAME, (String)null);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        ICProject cProject;
        String id;
        if (launch.getSourceLocator() == null && (id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, (String)null)) == null && (cProject = AbstractCLaunchDelegate.getCProject(configuration)) != null) {
            DefaultSourceLocator sourceLocator = new DefaultSourceLocator();
            sourceLocator.initializeDefaults(configuration);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    public String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, (String)null);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return AbstractCLaunchDelegate.parseArguments(this.getProgramArguments(config));
    }

    private static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    protected ICDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        ICDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = CDebugCorePlugin.getDefault().getDebugConfiguration(config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, ""));
        }
        catch (CoreException e) {
            Object result;
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 106, "CDT Debubger not installed", (Throwable)e);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler == null || (result = handler.handleStatus((IStatus)status, (Object)this)) instanceof String) {
                // empty if block
            }
            throw e;
        }
        return dbgCfg;
    }

    protected String renderTargetLabel(ICDebugConfiguration debugConfig) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, debugConfig.getName(), timestamp);
    }

    protected String renderProcessLabel(String commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine, timestamp);
    }

    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        ICProject cproject;
        String name = AbstractCLaunchDelegate.getProjectName(config);
        if (name == null) {
            this.abort("C project not specified", null, 102);
        }
        if ((cproject = AbstractCLaunchDelegate.getCProject(config)) == null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.exists()) {
                this.abort("Project does not exist", null, 103);
            } else if (!project.isOpen()) {
                this.abort("Project is closed", null, 103);
            }
            this.abort("Project is not a C/C++ project", null, 103);
        }
        return cproject;
    }

    protected IPath verifyProgramFile(ILaunchConfiguration config) throws CoreException {
        IFile projectPath;
        ICProject cproject = this.verifyCProject(config);
        String fileName = AbstractCLaunchDelegate.getProgramName(config);
        if (fileName == null) {
            this.abort("Program file not specified", null, 105);
        }
        if ((projectPath = ((IProject)cproject.getResource()).getFile(fileName)) == null || !projectPath.exists()) {
            this.abort("Program file does not exist", null, 104);
        }
        return projectPath.getLocation();
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            ICProject cp = AbstractCLaunchDelegate.getCProject(configuration);
            if (cp != null) {
                IProject p = cp.getProject();
                return p.getLocation().toFile();
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort("Working directory does not exist", null, 101);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort("Working directory does not exist", null, 101);
        }
        return null;
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            v = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        v.add(this.parseString());
                        continue;
                    }
                    v.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

