/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ICResource;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public abstract class CLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$ICElement;

    protected ICElement getContext(ILaunchConfiguration config, String platform) {
        IEditorPart part;
        ICResource ce;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        String programName = null;
        IWorkbenchPage page = LaunchUIPlugin.getActivePage();
        Object obj = null;
        try {
            projectName = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            programName = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_NAME, (String)null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (projectName != null && !projectName.equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                obj = cProject;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            obj = ss.getFirstElement();
        }
        if (obj instanceof IResource) {
            ce = CoreModel.getDefault().create((IResource)obj);
            if (ce == null) {
                IProject pro = ((IResource)obj).getProject();
                ce = CoreModel.getDefault().create(pro);
            }
            obj = ce;
        }
        if (obj instanceof ICElement) {
            if (platform != null && !platform.equals("*")) {
                ICDescriptor descriptor;
                try {
                    descriptor = CCorePlugin.getDefault().getCProjectDescription(((ICElement)obj).getCProject().getProject());
                }
                catch (CoreException e) {
                    return null;
                }
                String projectPlatform = descriptor.getPlatform();
                if (!projectPlatform.equals(platform) && !projectPlatform.equals("*")) {
                    obj = null;
                }
            }
            if (obj != null) {
                if (programName == null || programName.equals("")) {
                    return (ICElement)obj;
                }
                ce = (ICElement)obj;
                try {
                    IProject project = (IProject)ce.getCProject().getResource();
                    IPath programFile = project.getFile(programName).getLocation();
                    ce = CCorePlugin.getDefault().getCoreModel().create(programFile);
                    if (ce != null && ce.exists()) {
                        return ce;
                    }
                }
                catch (CModelException e) {
                    // empty catch block
                }
                return (ICElement)obj;
            }
        }
        if ((part = page.getActiveEditor()) != null) {
            IEditorInput input = part.getEditorInput();
            return (ICElement)input.getAdapter(class$org$eclipse$cdt$core$model$ICElement == null ? (class$org$eclipse$cdt$core$model$ICElement = CLaunchConfigurationTab.class$("org.eclipse.cdt.core.model.ICElement")) : class$org$eclipse$cdt$core$model$ICElement);
        }
        return null;
    }

    protected void initializeCProject(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = cElement.getCProject();
        String name = null;
        if (cProject != null && cProject.exists()) {
            name = cProject.getElementName();
        }
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
    }

    protected String getPlatform(ILaunchConfiguration config) {
        String platform = BootLoader.getOS();
        try {
            return config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PLATFORM, platform);
        }
        catch (CoreException e) {
            return platform;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

