/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CDebuggerPage
extends AbstractLaunchConfigurationTab {
    protected Text fDebuggerCommandText;
    private Button fAutoSoLibButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createVerticalSpacer(comp, 2);
        Label debugCommandLabel = new Label(comp, 0);
        debugCommandLabel.setText("MI Debugger:");
        this.fDebuggerCommandText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fDebuggerCommandText.setLayoutData((Object)gd);
        this.fDebuggerCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CDebuggerPage.super.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 2);
        this.fAutoSoLibButton = new Button(comp, 32);
        this.fAutoSoLibButton.setText("Load shared library symbols automatically");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAutoSoLibButton.setLayoutData((Object)gd);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, true);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fDebuggerCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage("Debugger executable must be specified");
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String debuggerCommand = "gdb";
        boolean autosolib = false;
        try {
            debuggerCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            autosolib = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, true);
        }
        catch (CoreException e) {
            // empty catch block
        }
        this.fDebuggerCommandText.setText(debuggerCommand);
        this.fAutoSoLibButton.setSelection(autosolib);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String debuggerCommand = this.fDebuggerCommandText.getText();
        debuggerCommand.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, debuggerCommand);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, this.fAutoSoLibButton.getSelection());
    }

    public String getName() {
        return "GDB/MI Debugger Options";
    }
}

