/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public class CDebugUtils {
    public static boolean question(IStatus status, Object source) {
        Boolean result = new Boolean(false);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                result = (Boolean)handler.handleStatus(status, source);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static void info(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void error(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static String toHexAddressString(long address) {
        String addressString = Long.toHexString(address);
        StringBuffer sb = new StringBuffer(10);
        sb.append("0x");
        int i = 0;
        while (i < 8 - addressString.length()) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public static char[] getByteText(byte b) {
        return new char[]{CDebugUtils.charFromByte((byte)(b >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(b & 0xF))};
    }

    public static byte textToByte(char[] text) {
        byte result = 0;
        if (text.length == 2) {
            byte[] bytes = new byte[]{CDebugUtils.charToByte(text[0]), CDebugUtils.charToByte(text[1])};
            result = (byte)((bytes[0] << 4) + bytes[1]);
        }
        return result;
    }

    public static char charFromByte(byte value) {
        if (value >= 0 && value <= 9) {
            return (char)(value + 48);
        }
        if (value >= 10 && value <= 15) {
            return (char)(value - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char ch) {
        if (Character.isDigit(ch)) {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(10 + ch - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] bytes) {
        try {
            return (char)Short.parseShort(new String(bytes), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }

    public static byte toByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (byte)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static short toUnsignedByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static short toShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static int toUnsignedShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static int toInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static long toUnsignedInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static long toLongLong(char[] bytes, boolean le) {
        if (bytes.length != 16) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static long toUnsignedLongLong(char[] bytes, boolean le) {
        return 0L;
    }

    private static String bytesToString(char[] bytes, boolean le, boolean signed) {
        char[] copy = new char[bytes.length];
        if (le) {
            int i = 0;
            while (i < bytes.length / 2) {
                copy[2 * i] = bytes[bytes.length - 2 * i - 2];
                copy[2 * i + 1] = bytes[bytes.length - 2 * i - 1];
                ++i;
            }
        } else {
            System.arraycopy(bytes, 0, copy, 0, copy.length);
        }
        return new String(copy);
    }

    public static String prependString(String text, int length, char ch) {
        StringBuffer sb = new StringBuffer(length);
        if (text.length() > length) {
            sb.append(text.substring(0, length));
        } else {
            char[] prefix = new char[length - text.length()];
            Arrays.fill(prefix, ch);
            sb.append(prefix);
            sb.append(text);
        }
        return sb.toString();
    }
}

