/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CProjectSourceLocation
implements IProjectSourceLocation {
    private IProject fProject;
    private HashMap fCache = new HashMap(20);
    private HashSet fNotFoundCache = new HashSet(20);
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public CProjectSourceLocation(IProject project) {
        this.setProject(project);
    }

    public Object findSourceElement(String name) throws CoreException {
        Object result = null;
        if (this.getProject() != null && !this.notFoundCacheLookup(name)) {
            result = this.cacheLookup(name);
            if (result == null && (result = this.doFindSourceElement(name)) != null) {
                this.cacheSourceElement(name, result);
            }
            if (result == null) {
                this.cacheNotFound(name);
            }
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = CProjectSourceLocation.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject)) {
            return this.getProject();
        }
        return null;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private Object doFindSourceElement(String name) {
        File file = new File(name);
        return file.isAbsolute() ? this.findFileByAbsolutePath(name) : this.findFileByRelativePath((IContainer)this.getProject(), name);
    }

    private Object findFileByAbsolutePath(String name) {
        Path path = new Path(name);
        return this.findFile((IContainer)this.getProject(), path.toOSString());
    }

    private Object findFileByRelativePath(IContainer container, String fileName) {
        IPath rootPath = container.getLocation();
        IPath path = rootPath.append(fileName);
        Object result = this.findFileByAbsolutePath(path.toOSString());
        if (result == null) {
            try {
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IFolder) {
                        path = members[i].getLocation().append(fileName);
                        result = this.findFileByAbsolutePath(path.toOSString());
                        if (result == null) {
                            result = this.findFileByRelativePath((IContainer)((IFolder)members[i]), fileName);
                        }
                        if (result != null) break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return result;
    }

    public IPath[] getPaths() {
        IPath location;
        IPath[] result = new IPath[]{};
        if (this.getProject() != null && (location = this.getProject().getLocation()) != null) {
            result = new IPath[]{location};
        }
        return result;
    }

    private Object findFile(IContainer container, String fileName) {
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                Object result;
                if (members[i] instanceof IFile) {
                    if (members[i].getLocation().toOSString().equals(fileName)) {
                        return members[i];
                    }
                } else if (members[i] instanceof IFolder && fileName.startsWith(members[i].getLocation().toOSString()) && (result = this.findFile((IContainer)members[i], fileName)) != null) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private Object cacheLookup(String name) {
        return this.fCache.get(name);
    }

    private boolean notFoundCacheLookup(String name) {
        return this.fNotFoundCache.contains(name);
    }

    private void cacheSourceElement(String name, Object element) {
        this.fCache.put(name, element);
    }

    private void cacheNotFound(String name) {
        this.fNotFoundCache.add(name);
    }

    protected void dispose() {
        this.fCache.clear();
        this.fNotFoundCache.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

