/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BuilderModel {
    private static BuilderModel buildModel = null;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_NAME = "cbuilder";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";

    public static String getBuilderName() {
        return BUILDER_NAME;
    }

    public static String getBuilderId() {
        return BUILDER_ID;
    }

    public void addBuildListener() {
    }

    public void removeBuildListener() {
    }

    public void build(IProject project, IPath workingDir, String[] args) {
    }

    public void addCToBuildSpec(IProject project) throws CoreException {
        this.addToBuildSpec(project, BuilderModel.getBuilderId());
    }

    public void addToBuildSpec(IProject project, String builderID) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand command = null;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
                break;
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
    }

    public void removeCFromBuildSpec(IProject project) throws CoreException {
        this.removeFromBuildSpec(project, BuilderModel.getBuilderId());
    }

    public void removeFromBuildSpec(IProject project, String builderID) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
            ++i;
        }
    }

    private BuilderModel() {
    }

    public static BuilderModel getDefault() {
        if (buildModel == null) {
            buildModel = new BuilderModel();
        }
        return buildModel;
    }
}

