/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.internal.core.model.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class Container
extends Resource
implements IContainer {
    public IResource findMember(String name) {
        return this.findMember(name, false);
    }

    public IResource findMember(String name, boolean phantom) {
        return this.findMember((IPath)new Path(name), phantom);
    }

    public IResource findMember(IPath path) {
        return this.findMember(path, false);
    }

    public IResource findMember(IPath path, boolean phantom) {
        path = this.getFullPath().append(path);
        try {
            IResource[] resources = this.members(phantom);
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getFullPath().equals((Object)path)) {
                    return resources[i];
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IFile getFile(String name) {
        return this.getFile((IPath)new Path(name));
    }

    public IFolder getFolder(String name) {
        return this.getFolder((IPath)new Path(name));
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean phantom) throws CoreException {
        return this.members(phantom ? 1 : 0);
    }

    public abstract IResource[] members(int var1) throws CoreException;

    public abstract boolean exists(IPath var1);

    public abstract IFile getFile(IPath var1);

    public abstract IFolder getFolder(IPath var1);

    public abstract IFile[] findDeletedMembersWithHistory(int var1, IProgressMonitor var2) throws CoreException;
}

