/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class Marker
extends PlatformObject
implements IMarker {
    private long id;
    private IResource resource;
    private HashMap attributes;
    private String type;

    public Marker(IResource res, String t) {
        this.resource = res;
        this.type = t;
        this.attributes = new HashMap();
        this.id = System.currentTimeMillis();
    }

    public void delete() throws CoreException {
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean exists() {
        return true;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Integer loc = (Integer)this.getAttribute(attributeName);
        if (loc != null) {
            return loc;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = (String)this.getAttribute(attributeName);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Boolean result = (Boolean)this.getAttribute(attributeName);
        if (result != null) {
            return true;
        }
        return defaultValue;
    }

    public Map getAttributes() throws CoreException {
        return this.attributes;
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 0;
        while (i < attributeNames.length) {
            Object attribute = this.getAttribute(attributeNames[i]);
            if (attribute != null) {
                results.add(attribute);
            }
            ++i;
        }
        return results.toArray();
    }

    public long getId() {
        return this.id;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getType() throws CoreException {
        return this.type;
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        return true;
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        this.attributes.put(attributeName, value);
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.setAttribute(attributeName, new Integer(value));
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.setAttribute(attributeName, new Boolean(value));
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        int i = 0;
        while (i < attributeNames.length) {
            this.attributes.put(attributeNames[i], values[i]);
            ++i;
        }
    }

    public void setAttributes(Map attributes) throws CoreException {
        attributes = (HashMap)attributes;
    }

    public void setId(long i) {
        this.id = i;
    }

    public long getCreationTime() throws CoreException {
        return this.id;
    }
}

