/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Marker;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;

public abstract class Resource
extends PlatformObject
implements IResource {
    ArrayList markers;
    Map sessionProperties;
    boolean readOnly;
    boolean derived;
    boolean teamPrivate;
    long stamp;
    boolean local;

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, depth, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 0, 2);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        boolean includeTeamPrivateMember;
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean bl = includeTeamPrivateMember = (memberFlags & 2) != 0;
        if (!includePhantoms && !this.exists()) {
            throw new CoreException((IStatus)new CModelStatus(4));
        }
        if (!includePhantoms && !this.getProject().isOpen()) {
            throw new CoreException((IStatus)new CModelStatus(4));
        }
        if ((!this.isPhantom() && !this.isTeamPrivateMember() || includePhantoms && this.isPhantom() || includeTeamPrivateMember && this.isTeamPrivateMember()) && !visitor.visit((IResource)this)) {
            return;
        }
        if (depth == 0) {
            return;
        }
        if (this.getType() == 1) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] members = ((IContainer)this).members(memberFlags);
        int i = 0;
        while (i < members.length) {
            members[i].accept(visitor, depth, memberFlags);
            ++i;
        }
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.copy(destination, force ? 1 : 0, monitor);
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        this.copy(description, force ? 1 : 0, monitor);
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject destProject = root.getProject(description.getName());
        IPath destination = destProject.getFullPath();
        this.copy(destination, updateFlags, monitor);
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int type = this.getType();
        if (type == 1) {
            IFile oFile = (IFile)this;
            IFile nFile = root.getFile(destination);
            nFile.create(oFile.getContents(), updateFlags, monitor);
        } else if (type == 2) {
            IFolder oFolder = (IFolder)this;
            IFolder nFolder = root.getFolder(destination);
            nFolder.create(updateFlags, true, monitor);
            IResource[] children = oFolder.members(2);
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                child.copy(destination.append(child.getName()), updateFlags, monitor);
                ++i;
            }
        }
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force ? 1 : 0, monitor);
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.move(destination, force ? 1 : 0, monitor);
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.move(description, (keepHistory ? 2 : 0) | (force ? 1 : 0), monitor);
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject destProject = root.getProject(description.getName());
        IPath destination = destProject.getFullPath();
        this.move(destination, updateFlags, monitor);
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.copy(destination, updateFlags, monitor);
        this.delete(updateFlags, monitor);
    }

    public IMarker createMarker(String type) throws CoreException {
        Marker marker = new Marker(this, type);
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        this.markers.add(marker);
        return marker;
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        if (this.markers != null) {
            this.markers.clear();
        }
    }

    public IMarker findMarker(long id) throws CoreException {
        if (this.markers != null) {
            int i = 0;
            while (i < this.markers.size()) {
                IMarker marker = (IMarker)this.markers.get(i);
                if (marker.getId() == id) {
                    return marker;
                }
                ++i;
            }
        }
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        if (this.markers != null) {
            ArrayList<IMarker> aList = new ArrayList<IMarker>();
            int i = 0;
            while (i < this.markers.size()) {
                IMarker marker = (IMarker)this.markers.get(i);
                if (marker.getType().equals(type)) {
                    aList.add(marker);
                }
                ++i;
            }
            return aList.toArray(new IMarker[0]);
        }
        return new IMarker[0];
    }

    public IMarker getMarker(long id) {
        IMarker marker;
        try {
            marker = this.findMarker(id);
            if (marker != null) {
                return marker;
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        marker = new Marker(this, "");
        marker.setId(id);
        return marker;
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        if (this.sessionProperties != null) {
            return this.sessionProperties.get(key);
        }
        return null;
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        if (this.sessionProperties == null) {
            this.sessionProperties = new HashMap(5);
        }
        this.sessionProperties.put(key, value);
    }

    public String getFileExtension() {
        return this.getFullPath().getFileExtension();
    }

    public IPath getLocation() {
        return this.getProject().getLocation().append(this.getFullPath());
    }

    public String getName() {
        return this.getFullPath().lastSegment();
    }

    public IProject getProject() {
        return this.getParent().getProject();
    }

    public IPath getProjectRelativePath() {
        return this.getFullPath().removeFirstSegments(this.getProject().getFullPath().segmentCount());
    }

    public IWorkspace getWorkspace() {
        return this.getProject().getWorkspace();
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
    }

    public boolean isAccessible() {
        int type = this.getType();
        if (type == 1 || type == 2) {
            return this.exists();
        }
        if (type == 4) {
            IProject project = (IProject)this;
            return this.exists() && project.isOpen();
        }
        return type == 8;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public boolean isLocal(int depth) {
        return !this.isPhantom();
    }

    public boolean isPhantom() {
        return !this.exists();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSynchronized(int depth) {
        if (this.getType() == 8) {
            if (depth == 0) {
                return true;
            }
            if (depth == 1) {
                depth = 0;
            }
            IProject[] projects = ((IWorkspaceRoot)this).getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isSynchronized(depth)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.exists();
    }

    public boolean isTeamPrivateMember() {
        return this.teamPrivate;
    }

    public void setDerived(boolean isDerived) throws CoreException {
        this.derived = isDerived;
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        this.local = flag;
        if (this.getType() == 1 || depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = ((IContainer)this).members();
        int i = 0;
        while (i < children.length) {
            children[i].setLocal(flag, depth, monitor);
            ++i;
        }
    }

    public void setReadOnly(boolean read) {
        this.readOnly = read;
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        this.teamPrivate = isTeamPrivate;
    }

    public abstract boolean exists();

    public abstract void refreshLocal(int var1, IProgressMonitor var2) throws CoreException;

    public abstract IPath getFullPath();

    public abstract IContainer getParent();

    public abstract int getType();

    public abstract long getModificationStamp();

    public abstract void delete(int var1, IProgressMonitor var2) throws CoreException;

    public abstract void touch(IProgressMonitor var1) throws CoreException;

    public abstract void setPersistentProperty(QualifiedName var1, String var2) throws CoreException;

    public abstract String getPersistentProperty(QualifiedName var1) throws CoreException;

    public boolean isLinked() {
        return false;
    }

    public IPath getRawLocation() {
        return this.getLocation();
    }
}

