/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.Symbol;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class ElfBinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile,
IBinaryParser.IBinaryObject,
IBinaryParser.IBinaryExecutable,
IBinaryParser.IBinaryShared {
    IFile file;
    String objectName;
    long timestamp;
    String soname;
    String[] needed;
    ElfHelper.Sizes sizes;
    Elf.Attribute attribute;
    ArrayList symbols;

    public ElfBinaryFile(IFile f) throws IOException {
        this(f, null);
    }

    public ElfBinaryFile(IFile f, String n) throws IOException {
        this.file = f;
        this.objectName = n;
        this.loadInformation();
        this.hasChanged();
    }

    public IFile getFile() {
        return this.file;
    }

    public long getBSS() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.bss;
        }
        return 0L;
    }

    public String getCPU() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.data;
        }
        return 0L;
    }

    public long getText() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.text;
        }
        return 0L;
    }

    public String getSoName() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.soname != null) {
            return this.soname;
        }
        return "";
    }

    public boolean hasDebug() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.isLittleEndian();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.needed != null) {
            return this.needed;
        }
        return new String[0];
    }

    public int getType() {
        int type = 0;
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            switch (this.attribute.getType()) {
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 4;
                    break;
                }
                case 3: {
                    type = 1;
                    break;
                }
                case 4: {
                    type = 16;
                }
            }
        }
        return type;
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            if (this.symbols == null) {
                this.symbols = new ArrayList(5);
            }
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.symbols.toArray(new IBinaryParser.ISymbol[0]);
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.file != null && this.objectName != null) {
            IPath location = this.file.getLocation();
            if (location != null) {
                AR ar = null;
                try {
                    ar = new AR(this.file.getLocation().toOSString());
                    AR.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        if (this.objectName.equals(headers[i].getObjectName())) {
                            stream = new ByteArrayInputStream(headers[i].getObjectData());
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (ar != null) {
                    ar.dispose();
                }
            }
        } else if (this.file != null && this.file.exists()) {
            try {
                stream = this.file.getContents();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (stream == null) {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    public String getName() {
        if (this.objectName != null) {
            return this.objectName;
        }
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public String toString() {
        return this.getName();
    }

    protected Elf.Attribute getAttribute() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.attribute;
    }

    protected ElfHelper.Sizes getSizes() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sizes;
    }

    boolean hasChanged() {
        long modification = this.file.getModificationStamp();
        boolean changed = modification != this.timestamp;
        this.timestamp = modification;
        return changed;
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.file != null && this.objectName != null) {
            IPath location = this.file.getLocation();
            if (location != null) {
                ElfHelper helper = null;
                AR ar = null;
                try {
                    ar = new AR(this.file.getLocation().toOSString());
                    AR.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        AR.ARHeader hdr = headers[i];
                        if (this.objectName.equals(hdr.getObjectName())) {
                            helper = new ElfHelper(hdr.getElf());
                            break;
                        }
                        ++i;
                    }
                    Object var8_8 = null;
                    if (ar != null) {
                        ar.dispose();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (ar != null) {
                        ar.dispose();
                    }
                    throw throwable;
                }
                if (helper != null) {
                    return helper;
                }
            }
        } else if (this.file != null && this.file.exists()) {
            IPath path = this.file.getLocation();
            if (path == null) {
                path = new Path("");
            }
            return new ElfHelper(path.toOSString());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void loadInformation() throws IOException {
        ElfHelper helper = this.getElfHelper();
        this.loadInformation(helper);
        helper.dispose();
    }

    private void loadInformation(ElfHelper helper) throws IOException {
        this.loadAttributes(helper);
        if (this.symbols != null) {
            this.symbols.clear();
            this.loadSymbols(helper);
            this.symbols.trimToSize();
        }
    }

    private void loadAttributes(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
    }

    private void loadSymbols(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
        this.addSymbols(helper.getExternalFunctions(), 1);
        this.addSymbols(helper.getLocalFunctions(), 1);
        this.addSymbols(helper.getExternalObjects(), 2);
        this.addSymbols(helper.getLocalObjects(), 2);
        this.symbols.trimToSize();
    }

    private void addSymbols(Elf.Symbol[] array, int type) {
        int i = 0;
        while (i < array.length) {
            try {
                Symbol sym = new Symbol();
                sym.filename = array[i].getFilename();
                sym.name = array[i].toString();
                sym.lineno = array[i].getFuncLineNumber();
                sym.type = type;
                this.symbols.add(sym);
            }
            catch (IOException e) {
                // empty catch block
            }
            ++i;
        }
    }
}

