/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class GCCErrorParser
implements IErrorParser {
    public boolean processLine(String line, ErrorParserManager eoParser) {
        block35: {
            int firstColon;
            block34: {
                firstColon = line.indexOf(58);
                if (firstColon == 1) {
                    try {
                        String os = System.getProperty("os.name");
                        if (os == null || !os.startsWith("Win")) break block34;
                        try {
                            if (Character.isLetter(line.charAt(0))) {
                                firstColon = line.indexOf(58, 2);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {}
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
            }
            if (firstColon != -1) {
                try {
                    int secondColon = line.indexOf(58, firstColon + 1);
                    if (secondColon == -1) break block35;
                    String fileName = line.substring(0, firstColon);
                    String lineNumber = line.substring(firstColon + 1, secondColon);
                    String varName = null;
                    String desc = line.substring(secondColon + 1).trim();
                    int severity = 2;
                    int num = -1;
                    int col = -1;
                    try {
                        num = Integer.parseInt(lineNumber);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (num == -1) {
                        return false;
                    }
                    int thirdColon = line.indexOf(58, secondColon + 1);
                    if (thirdColon != -1) {
                        String columnNumber = line.substring(secondColon + 1, thirdColon);
                        try {
                            col = Integer.parseInt(columnNumber);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (col != -1) {
                        desc = line.substring(thirdColon + 1).trim();
                    }
                    if (desc.startsWith("(Each undeclared")) {
                        return false;
                    }
                    String previous = eoParser.getPreviousLine();
                    if (desc.endsWith(")") && previous.indexOf("(Each undeclared") >= 0) {
                        return false;
                    }
                    int s = desc.indexOf("' undeclared");
                    if (s != -1) {
                        int p = desc.indexOf("`");
                        if (p != -1) {
                            varName = desc.substring(p + 1, s);
                        }
                    } else {
                        s = desc.indexOf("' defined but not used");
                        if (s != -1) {
                            int p = desc.indexOf("`");
                            if (p != -1) {
                                varName = desc.substring(p + 1, s);
                            }
                        } else {
                            s = desc.indexOf("conflicting types for `");
                            if (s != -1) {
                                int p = desc.indexOf("'", s);
                                if (p != -1) {
                                    varName = desc.substring(desc.indexOf("`") + 1, p);
                                }
                            } else {
                                int p;
                                s = desc.indexOf("previous declaration of `");
                                if (s != -1 && (p = desc.indexOf("'", s)) != -1) {
                                    varName = desc.substring(desc.indexOf("`") + 1, p);
                                }
                            }
                        }
                    }
                    IFile file = eoParser.findFilePath(fileName);
                    if (file == null && (file = eoParser.findFileName(fileName)) != null && eoParser.isConflictingName(fileName)) {
                        desc = "*" + desc;
                        file = null;
                    }
                    if (desc.startsWith("warning") || desc.startsWith("Warning")) {
                        severity = 1;
                        String d = desc.substring("warning".length()).trim();
                        if (d.startsWith(":")) {
                            d = d.substring(1).trim();
                        }
                        if (d.length() != 0) {
                            desc = d;
                        }
                    }
                    if (file == null) {
                        desc = desc + "[" + fileName + "]";
                    }
                    eoParser.generateMarker((IResource)file, num, desc, severity, varName);
                }
                catch (StringIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

