/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;

public class PTY {
    String slave;
    public int master;
    InputStream in;
    OutputStream out;
    private static boolean hasPTY;

    public PTY() throws IOException {
        if (hasPTY) {
            this.slave = this.forkpty();
        }
        if (this.slave == null) {
            throw new IOException("Can not create pty");
        }
        this.in = new PTYInputStream(this.master);
        this.out = new PTYOutputStream(this.master);
    }

    public String getSlaveName() {
        return this.slave;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    native String forkpty();

    static {
        try {
            System.loadLibrary("pty");
            hasPTY = true;
        }
        catch (SecurityException e) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

