/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.linux;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.internal.core.linux.ProcessInfo;

public class ProcessList
implements IProcessList {
    ProcessInfo[] empty = new ProcessInfo[0];

    /*
     * WARNING - void declaration
     */
    public IProcessInfo[] getProcessList() {
        File proc = new File("/proc");
        File[] pidFiles = null;
        try {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    boolean isPID = false;
                    try {
                        Integer.parseInt(name);
                        isPID = true;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    return isPID;
                }
            };
            pidFiles = proc.listFiles(filter);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        IProcessInfo[] processInfo = this.empty;
        if (pidFiles != null) {
            processInfo = new ProcessInfo[pidFiles.length];
            int i = 0;
            while (i < pidFiles.length) {
                File cmdLine = new File(pidFiles[i], "cmdline");
                StringBuffer line = new StringBuffer();
                try {
                    int c;
                    FileReader reader = new FileReader(cmdLine);
                    while ((c = reader.read()) > 0) {
                        void var8_10;
                        line.append((char)var8_10);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                String name = line.toString();
                if (name.length() == 0) {
                    name = "Unknown";
                }
                processInfo[i] = new ProcessInfo(pidFiles[i].getName(), name);
                ++i;
            }
        } else {
            pidFiles = new File[]{};
        }
        return processInfo;
    }
}

