/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryFormatAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fFormat = 0;

    public MemoryFormatAction(MemoryActionSelectionGroup group, MemoryViewer viewer, int format) {
        super(MemoryFormatAction.getLabel(format));
        this.fGroup = group;
        this.fMemoryViewer = viewer;
        this.fFormat = format;
        this.setChecked(false);
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canChangeFormat(this.fFormat));
        this.setChecked(this.fMemoryViewer.getCurrentFormat() == this.fFormat);
    }

    public void run() {
        try {
            this.fMemoryViewer.setFormat(this.fFormat);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog("Unable to change format.", e.getStatus());
            this.setChecked(false);
        }
    }

    private static String getLabel(int id) {
        String label = "";
        switch (id) {
            case 0: {
                label = "Hexadecimal";
                break;
            }
            case 3: {
                label = "Signed Decimal";
                break;
            }
            case 4: {
                label = "Unsigned Decimal";
            }
        }
        return label;
    }

    public String getActionId() {
        return "MemoryFormat" + this.fFormat;
    }
}

