/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorTextHoverDispatcher;
import org.eclipse.cdt.internal.ui.text.CAnnotationHover;
import org.eclipse.cdt.internal.ui.text.CAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCommentAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCompletionProcessor;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "org.eclipse.cdt.editor.tab.width";
    private static final String CODE_FORMATTER_TAB_SIZE = "org.eclipse.cdt.formatter.tabulation.size";
    private static final String CODE_FORMATTER_TAB_CHAR = "org.eclipse.cdt.formatter.tabulation.char";
    private CTextTools fTextTools;
    private CEditor fEditor;

    public CSourceViewerConfiguration(CTextTools tools, CEditor editor) {
        this.fTextTools = tools;
        this.fEditor = editor;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fTextTools.getMultilineCommentScanner();
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fTextTools.getSinglelineCommentScanner();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fTextTools.getStringScanner();
    }

    protected IColorManager getColorManager() {
        return this.fTextTools.getColorManager();
    }

    protected ITextEditor getEditor() {
        return this.fEditor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        String language;
        PresentationReconciler reconciler = new PresentationReconciler();
        RuleBasedScanner scanner = sourceViewer instanceof CEditor.AdaptedSourceViewer ? ((language = ((CEditor.AdaptedSourceViewer)sourceViewer).getDisplayLanguage()) != null && language.equals("CEditor.language.cpp") ? this.fTextTools.getCppCodeScanner() : this.fTextTools.getCCodeScanner()) : this.fTextTools.getCCodeScanner();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_single_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_single_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_multi_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_multi_line_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new CCompletionProcessor((IEditorPart)this.fEditor), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            Reconciler reconciler = new Reconciler();
            reconciler.setDelay(1000);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setReconcilingStrategy((IReconcilingStrategy)new CReconcilingStrategy(this.fEditor), "__dftl_partition_content_type");
            return reconciler;
        }
        return null;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("c_multi_line_comment".equals(contentType)) {
            return new CCommentAutoIndentStrategy();
        }
        return new CAutoIndentStrategy();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new CDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return "//";
        }
        if ("c_single_line_comment".equals(contentType)) {
            return "//";
        }
        if ("c_multi_line_comment".equals(contentType)) {
            return "//";
        }
        return null;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int tabWidth = this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
        boolean useSpaces = this.getPreferenceStore().getBoolean("spacesForTabs");
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new CAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        HashMap textHovers = new HashMap(3);
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(CUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), "textHovers");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement config = configElements[j];
                    if (config.getName().equals("textHover")) {
                        this.processTextHoverElement(textHovers, config);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return new CEditorTextHoverDispatcher((IEditorPart)this.fEditor, textHovers);
    }

    private void processTextHoverElement(HashMap textHovers, IConfigurationElement element) {
        String perspId = element.getAttribute("perspective");
        ITextHover textHover = null;
        try {
            textHover = (ITextHover)element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (perspId != null) {
            textHovers.put(perspId, textHover);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "c_multi_line_comment", "c_single_line_comment", "c_string"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        String[] types = new String[]{"__content_types_category"};
        ContentFormatter formatter = new ContentFormatter();
        CFormattingStrategy strategy = new CFormattingStrategy(sourceViewer);
        formatter.setFormattingStrategy((IFormattingStrategy)strategy, "__dftl_partition_content_type");
        formatter.enablePartitionAwareFormatting(false);
        formatter.setPartitionManagingPositionCategories(types);
        return formatter;
    }

    protected IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(sourceViewer, true);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer, final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        return super.getInformationPresenter(sourceViewer);
    }
}

