/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.link;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionListener;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.util.Assert;

public class LinkedPositionManager
implements IDocumentListener,
IPositionUpdater {
    private static final String LINKED_POSITION = "LinkedPositionManager.linked.position";
    private static final Comparator fgPositionComparator = new PositionComparator();
    private static final Map fgActiveManagers = new HashMap();
    private IDocument fDocument;
    private LinkedPositionListener fListener;

    public LinkedPositionManager(IDocument document) {
        Assert.isNotNull((Object)document);
        this.fDocument = document;
        this.install();
    }

    public void setLinkedPositionListener(LinkedPositionListener listener) {
        this.fListener = listener;
    }

    public void addPosition(int offset, int length) throws BadLocationException {
        String type;
        Position[] positions = LinkedPositionManager.getPositions(this.fDocument);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                if (LinkedPositionManager.collides(positions[i], offset, length)) {
                    throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.position.collision"));
                }
                ++i;
            }
        }
        if (this.containsLineDelimiters(type = this.fDocument.get(offset, length))) {
            throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.contains.line.delimiters"));
        }
        try {
            this.fDocument.addPosition(LINKED_POSITION, (Position)new TypedPosition(offset, length, type));
        }
        catch (BadPositionCategoryException e) {
            CUIPlugin.log(e);
            Assert.isTrue((boolean)false);
        }
    }

    public static boolean hasActiveManager(IDocument document) {
        return fgActiveManagers.get(document) != null;
    }

    private void install() {
        LinkedPositionManager manager = (LinkedPositionManager)fgActiveManagers.get(this.fDocument);
        if (manager != null) {
            manager.leave(true);
        }
        fgActiveManagers.put(this.fDocument, this);
        this.fDocument.addPositionCategory(LINKED_POSITION);
        this.fDocument.addPositionUpdater((IPositionUpdater)this);
        this.fDocument.addDocumentListener((IDocumentListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(boolean success) {
        this.fDocument.removeDocumentListener((IDocumentListener)this);
        try {
            try {
                Position[] positions = LinkedPositionManager.getPositions(this.fDocument);
                if (!success && positions != null) {
                    int i = 0;
                    while (i != positions.length) {
                        TypedPosition position = (TypedPosition)positions[i];
                        this.fDocument.replace(position.getOffset(), position.getLength(), position.getType());
                        ++i;
                    }
                }
                this.fDocument.removePositionCategory(LINKED_POSITION);
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
                Assert.isTrue((boolean)false);
                Object var6_8 = null;
                this.fDocument.removePositionUpdater((IPositionUpdater)this);
                fgActiveManagers.remove(this.fDocument);
                return;
            }
            catch (BadPositionCategoryException e) {
                CUIPlugin.log(e);
                Assert.isTrue((boolean)false);
                Object var6_9 = null;
                this.fDocument.removePositionUpdater((IPositionUpdater)this);
                fgActiveManagers.remove(this.fDocument);
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.fDocument.removePositionUpdater((IPositionUpdater)this);
            fgActiveManagers.remove(this.fDocument);
            throw throwable;
        }
        this.fDocument.removePositionUpdater((IPositionUpdater)this);
        fgActiveManagers.remove(this.fDocument);
    }

    public Position getFirstPosition() {
        return this.getNextPosition(-1);
    }

    public Position getNextPosition(int offset) {
        Position[] positions = LinkedPositionManager.getPositions(this.fDocument);
        return LinkedPositionManager.findNextPosition(positions, offset);
    }

    private static Position findNextPosition(Position[] positions, int offset) {
        int i = 0;
        while (i != positions.length) {
            if (positions[i].getOffset() > offset) {
                String type = ((TypedPosition)positions[i]).getType();
                int j = 0;
                while (j != i) {
                    if (((TypedPosition)positions[j]).getType().equals(type)) break;
                    ++j;
                }
                if (j == i) {
                    return positions[i];
                }
            }
            ++i;
        }
        return null;
    }

    public Position getPreviousPosition(int offset) {
        Position[] positions = LinkedPositionManager.getPositions(this.fDocument);
        if (positions == null) {
            return null;
        }
        Position lastPosition = null;
        Position position = this.getFirstPosition();
        while (position != null && position.getOffset() < offset) {
            lastPosition = position;
            position = LinkedPositionManager.findNextPosition(positions, position.getOffset());
        }
        return lastPosition;
    }

    private static Position[] getPositions(IDocument document) {
        try {
            Position[] positions = document.getPositions(LINKED_POSITION);
            Arrays.sort(positions, fgPositionComparator);
            return positions;
        }
        catch (BadPositionCategoryException e) {
            CUIPlugin.log(e);
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static boolean includes(Position position, int offset, int length) {
        return offset >= position.getOffset() && offset + length <= position.getOffset() + position.getLength();
    }

    public static boolean excludes(Position position, int offset, int length) {
        return offset + length <= position.getOffset() || position.getOffset() + position.getLength() <= offset;
    }

    private static boolean collides(Position position, int offset, int length) {
        return offset <= position.getOffset() + position.getLength() && position.getOffset() <= offset + length;
    }

    private void leave(boolean success) {
        this.uninstall(success);
        if (this.fListener != null) {
            this.fListener.exit(success);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        IDocument document = event.getDocument();
        Position[] positions = LinkedPositionManager.getPositions(document);
        Position position = LinkedPositionManager.findCurrentEditablePosition(positions, event.getOffset());
        if (position == null) {
            position = LinkedPositionManager.findCurrentPosition(positions, event.getOffset());
            if (position == null) {
                if (event.getText().length() == 0 && LinkedPositionManager.findCurrentPosition(positions, event.getOffset()) != null && LinkedPositionManager.findCurrentPosition(positions, event.getOffset() + event.getLength()) != null) {
                    this.leave(true);
                }
            } else {
                this.leave(true);
            }
        } else if (LinkedPositionManager.includes(position, event.getOffset(), event.getLength())) {
            if (this.containsLineDelimiters(event.getText())) {
                this.leave(true);
            }
        } else {
            this.leave(true);
        }
    }

    public void documentChanged(DocumentEvent event) {
        IDocument document = event.getDocument();
        Position[] positions = LinkedPositionManager.getPositions(document);
        TypedPosition currentPosition = (TypedPosition)LinkedPositionManager.findCurrentEditablePosition(positions, event.getOffset());
        if (currentPosition == null) {
            return;
        }
        int deltaOffset = event.getOffset() - currentPosition.getOffset();
        if (this.fListener != null) {
            this.fListener.setCurrentPosition((Position)currentPosition, deltaOffset + event.getText().length());
        }
        int i = 0;
        while (i != positions.length) {
            TypedPosition p = (TypedPosition)positions[i];
            if (p.getType().equals(currentPosition.getType()) && !p.equals((Object)currentPosition)) {
                Replace replace = new Replace((Position)p, deltaOffset, event.getLength(), event.getText());
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)replace);
            }
            ++i;
        }
    }

    public void update(DocumentEvent event) {
        int deltaLength = event.getText().length() - event.getLength();
        Position[] positions = LinkedPositionManager.getPositions(event.getDocument());
        TypedPosition currentPosition = (TypedPosition)LinkedPositionManager.findCurrentPosition(positions, event.getOffset());
        if (currentPosition == null) {
            int i = 0;
            while (i != positions.length) {
                TypedPosition position = (TypedPosition)positions[i];
                int offset = position.getOffset();
                if (offset >= event.getOffset()) {
                    position.setOffset(offset + deltaLength);
                }
                ++i;
            }
        } else {
            int length = currentPosition.getLength();
            int i = 0;
            while (i != positions.length) {
                TypedPosition position = (TypedPosition)positions[i];
                int offset = position.getOffset();
                if (position.equals((Object)currentPosition)) {
                    position.setLength(length + deltaLength);
                } else if (offset > currentPosition.getOffset()) {
                    position.setOffset(offset + deltaLength);
                }
                ++i;
            }
        }
    }

    private static Position findCurrentPosition(Position[] positions, int offset) {
        int i = 0;
        while (i != positions.length) {
            if (LinkedPositionManager.includes(positions[i], offset, 0)) {
                return positions[i];
            }
            ++i;
        }
        return null;
    }

    private static Position findCurrentEditablePosition(Position[] positions, int offset) {
        Position position = positions[0];
        while (position != null && !LinkedPositionManager.includes(position, offset, 0)) {
            position = LinkedPositionManager.findNextPosition(positions, position.getOffset());
        }
        return position;
    }

    private boolean containsLineDelimiters(String string) {
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        int i = 0;
        while (i != delimiters.length) {
            if (string.indexOf(delimiters[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean anyPositionIncludes(int offset, int length) {
        Position[] positions = LinkedPositionManager.getPositions(this.fDocument);
        Position position = LinkedPositionManager.findCurrentEditablePosition(positions, offset);
        if (position == null) {
            return false;
        }
        return LinkedPositionManager.includes(position, offset, length);
    }

    private class Replace
    implements IDocumentExtension.IReplace {
        private Position fReplacePosition;
        private int fReplaceDeltaOffset;
        private int fReplaceLength;
        private String fReplaceText;

        public Replace(Position position, int deltaOffset, int length, String text) {
            this.fReplacePosition = position;
            this.fReplaceDeltaOffset = deltaOffset;
            this.fReplaceLength = length;
            this.fReplaceText = text;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            document.removeDocumentListener(owner);
            try {
                document.replace(this.fReplacePosition.getOffset() + this.fReplaceDeltaOffset, this.fReplaceLength, this.fReplaceText);
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
            document.addDocumentListener(owner);
        }
    }

    private static class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object object0, Object object1) {
            Position position0 = (Position)object0;
            Position position1 = (Position)object1;
            return position0.getOffset() - position1.getOffset();
        }
    }
}

