/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.ListenerList;

public class ProblemMarkerManager
implements IResourceChangeListener {
    private ListenerList fListeners = new ListenerList(5);

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet changedElements = new HashSet();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e.getStatus());
        }
        if (changedElements.size() > 0) {
            this.fireChanges(changedElements);
        }
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    private void fireChanges(Set changes) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IProblemChangedListener curr = (IProblemChangedListener)listeners[i];
            curr.problemsChanged(changes);
            ++i;
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet fChangedElements;

        public ProjectErrorVisitor(HashSet changedElements) {
            this.fChangedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4) {
                try {
                    IProject project = (IProject)res;
                    if (!project.isAccessible() || !project.hasNature("org.eclipse.cdt.core.cnature")) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log(e.getStatus());
                    return false;
                }
            }
            this.checkInvalidate(delta, res.getFullPath());
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IPath path) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (!(path.isEmpty() || path.isRoot() || this.fChangedElements.contains(path))) {
                    this.fChangedElements.add(path);
                    path = path.removeLastSegments(1);
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
                int i = 0;
                while (i < markerDeltas.length) {
                    if (markerDeltas[i].isSubtypeOf("org.eclipse.cdt.core.problem")) {
                        int kind = markerDeltas[i].getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = markerDeltas[i].getAttribute("severity", -1);
                        int newSeverity = markerDeltas[i].getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

